﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

using namespace System;
using namespace System::ComponentModel;
using namespace System::Diagnostics;
using namespace System::Collections::Generic;

#include "G3dHioLibDefs.h"
#include <nw/g3d/edit/detail/g3d_EditDetailDefs.h>

namespace NintendoWare {
namespace G3d {
namespace Edit {

private ref class LoadAnimCommand : public EditAnimCommand
{
public:
    LoadAnimCommand(TargetEndianKind targetEndian, IEditTarget^ target, FileData^ fileData,
        nw::g3d::edit::detail::FileDataKind fileKind)
        : EditAnimCommand(targetEndian, target)
        , m_FileData(gcnew FileData())
    {
        m_FileData->Alignment = fileData->Alignment;
        m_FileData->FileName = dynamic_cast<String^>(fileData->FileName->Clone());
        m_FildDataKind = fileKind;
    }

    // スケルタルアニメーション用
    LoadAnimCommand(
        TargetEndianKind targetEndian,
        IEditTarget^ target,
        FileData^ fileData,
        String^ retargetingHostName)
        : EditAnimCommand(targetEndian, target)
        , m_FileData(gcnew FileData())
        , m_RetargetingHostModelName(String::Empty)
    {
        m_FileData->Alignment = fileData->Alignment;
        m_FileData->FileName = dynamic_cast<String^>(fileData->FileName->Clone());
        m_FildDataKind = nw::g3d::edit::detail::FILEDATA_SKELETAL_ANIM;

        if (!String::IsNullOrEmpty(retargetingHostName))
        {
            m_RetargetingHostModelName = gcnew String(retargetingHostName);
        }
    }

    virtual bool MakeCommandPacket() override;

    virtual property bool IsInOrder
    {
        bool get() override
        {
            return true;
        }
    }

protected:
    virtual bool CanProcessImpl() override
    {
        if (Target->ResFileKey == 0)
        {
            return true;
        }
        return false;
    }
private:
    initonly FileData^ m_FileData;
    String^ m_RetargetingHostModelName;
    nw::g3d::edit::detail::FileDataKind m_FildDataKind;
};

private ref class ReloadAnimCommand : public EditAnimCommand
{
public:
    ReloadAnimCommand(TargetEndianKind targetEndian, IEditTarget^ target, FileData^ fileData,
        nw::g3d::edit::detail::FileDataKind fileKind)
        : EditAnimCommand(targetEndian, target)
        , m_FileData(gcnew FileData())
    {
        m_FileData->Alignment = fileData->Alignment;
        m_FileData->FileName = dynamic_cast<String^>(fileData->FileName->Clone());
        m_FildDataKind = fileKind;
    }

    virtual bool MakeCommandPacket() override;

    virtual property bool IsInOrder
    {
        bool get() override
        {
            return true;
        }
    }

private:
    initonly FileData^ m_FileData;
    nw::g3d::edit::detail::FileDataKind m_FildDataKind;
};

private ref class UnloadAnimCommand : public EditAnimCommand
{
public:
    UnloadAnimCommand(TargetEndianKind targetEndian, IEditTarget^ target, nw::g3d::edit::detail::FileDataKind fileKind)
        : EditAnimCommand(targetEndian, target)
    {
        m_ReservedResFileKey = target->ResFileKey;
        m_FildDataKind = fileKind;
    }

    virtual bool MakeCommandPacket() override;

    virtual property bool IsInOrder
    {
        bool get() override
        {
            return true;
        }
    }

    virtual void OnRemoved() override
    {
        Target->ResetStatus();
    }

protected:
    virtual bool CanProcessImpl() override
    {
        if (m_ReservedResFileKey > 0)
        {
            return true;
        }
        return false;
    }

private:
    UINT32 m_ReservedResFileKey;
    nw::g3d::edit::detail::FileDataKind m_FildDataKind;
};

}}} // namespace NintendoWare.G3d.Edit
