﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "stdafx.h"

using namespace System::Diagnostics;

#include "HtcCommDevice.h"
#include <nw/g3d/edit/g3d_EditDefs.h>

namespace {

const std::string CHANNEL_NAME = nw::g3d::edit::detail::EDIT_CHANNEL_NAME;
const std::string PING_CHANNEL_NAME = nw::g3d::edit::detail::EDIT_PING_CHANNEL_NAME;

} // anonymous namespace

namespace NintendoWare { namespace G3d { namespace Edit {

HtcCommDevice::HtcCommDevice(RecvInfo^ recvInfo, System::String^ peerType, System::String^ peerName) :
    CommDevice(6000, recvInfo, false),
    PeerType(peerType),
    PeerName(peerName)
{
}

HtcCommDevice::~HtcCommDevice()
{
}
HtcCommDevice::!HtcCommDevice()
{
}

NintendoWare::G3d::Edit::HtcResult^ HtcCommDevice::Connect()
{
    NintendoWare::G3d::Edit::HtcResult^ result;
    System::Net::IPEndPoint^ endPoint = ResolvePortMapping(PeerType, PeerName, gcnew System::String(CHANNEL_NAME.c_str()));
    if (endPoint != nullptr)
    {
        m_PortNumber = endPoint->Port;

        if (m_IsConnected)
        {
            CloseConnection();
            OpenConnection();
        }

        result = m_Client->Connect(m_PortNumber);
        IsConnected = result->IsSuccess;
        return result;
    }

    result = gcnew NintendoWare::G3d::Edit::HtcResult();
    result->ResultCode = HtcResultCode::ValidEditPortNotFound;
    return result;
}

NintendoWare::G3d::Edit::HtcResult^ HtcCommDevice::ConnectPing()
{
    NintendoWare::G3d::Edit::HtcResult^ result;
    System::Net::IPEndPoint^ endPoint = ResolvePortMapping(PeerType, PeerName, gcnew System::String(PING_CHANNEL_NAME.c_str()));
    if (endPoint != nullptr)
    {
        m_PingPortNumber = endPoint->Port;

        if (m_IsPingConnected)
        {
            CloseConnection();
            OpenConnection();
        }

        result = m_Client->ConnectPing(m_PingPortNumber);
        IsPingConnected = result->IsSuccess;
        return result;
    }

    result = gcnew NintendoWare::G3d::Edit::HtcResult();
    result->ResultCode = HtcResultCode::ValidEditPortNotFound;
    return result;
}

}}} // namespace NintendoWare.G3d.Edit
