﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

using namespace System;
using namespace System::ComponentModel;
using namespace System::Diagnostics;
using namespace System::Collections::Generic;

#include "G3dHioLibDefs.h"
#include <nw/g3d/edit/detail/g3d_EditDetailDefs.h>

namespace NintendoWare {
namespace G3d {
namespace Edit {

generic<typename ValueType>// where ValueType : value struct
private ref class EditBoneValueCommand : public EditIndicesModelCommand<ValueType>
{
public:
    EditBoneValueCommand(TargetEndianKind targetEndian, IEditModelTarget^ target, array<INT32>^ boneIndices, ValueType value, nw::g3d::edit::detail::EditTargetKind editTargetKind)
        : EditIndicesModelCommand<ValueType>(targetEndian, target, boneIndices, value)
    {
        m_EditTargetKind = editTargetKind;
    }

    virtual bool MakeCommandPacket() override;

protected:
    virtual bool CanProcessImpl() override
    {
        if (Target->ModelObjKey > 0)
        {
            return true;
        }
        return false;
    }

private:
    nw::g3d::edit::detail::EditTargetKind m_EditTargetKind;
};

}}} // namespace NintendoWare.G3d.Edit
