﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/g3d/res/g3d_ResDictionary.h>
#include "EditBinaryBlock.h"

namespace nw {
namespace g3d {
namespace tool {

class EditBinDictionary : public EditBinaryBlock
{
public:
    EditBinDictionary()
        : EditBinaryBlock()
        , m_NameArray()
    {
    }

    void Build(Context& ctx, size_t dicSize);
    virtual void CalcSize();
    virtual void Convert(const Context& ctx);

    void SetName(int index, const std::string& name) { m_NameArray[index] = &name; }
    static void SetData(ResDicType::DataType* pDic, int index, void* pData)
    {
        // データ設定時には辞書のアドレスがわかっているのでアドレスを受け取る。
        pDic->node[index + 1].ofsData.set_ptr(pData);
    }

    template <typename T>
    void ConvertData(const Context& ctx, Offset& ofsDic, std::vector<T>& dataArray)
    {
        ResDicType::DataType* pDic = GetPtr<ResDicType::DataType>(ctx.pBuf);
        ofsDic.set_ptr(pDic);
        int index = 0;
        for (auto iter = dataArray.begin(); iter != dataArray.end(); ++iter, ++index)
        {
            BinDictionary::SetData(pDic, index, iter->GetPtr(ctx.pBuf));
        }
    }

    template <typename T>
    void ConvertArrayData(const Context& ctx, Offset& ofsDic, T* pData, int count)
    {
        ResDicType::DataType* pDic = GetPtr<ResDicType::DataType>(ctx.pBuf);
        ofsDic.set_ptr(pDic);
        for (int index = 0; index < count; ++index, ++pData)
        {
            BinDictionary::SetData(pDic, index, pData);
        }
    }
private:
    std::vector<const std::string*> m_NameArray;
};


}}} // namespace nw::g3d::tool
