﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "stdafx.h"

#include "CafeCommDevice.h"
#include <nw/g3d/edit/g3d_EditDefs.h>

using namespace System::Diagnostics;

namespace {

const std::string CHANNEL_NAME = nw::g3d::edit::detail::EDIT_CHANNEL_NAME;
const std::string ENABLE_CHNNEL_NAME = "+" + CHANNEL_NAME;
const std::string DISABLE_CHNNEL_NAME = "-" + CHANNEL_NAME;

const std::string PING_CHANNEL_NAME = nw::g3d::edit::detail::EDIT_PING_CHANNEL_NAME;
const std::string ENABLE_PING_CHNNEL_NAME = "+" + PING_CHANNEL_NAME;
const std::string DISABLE_PING_CHNNEL_NAME = "-" + PING_CHANNEL_NAME;

const u_short CAFE_HIO_OPEN_PORT = 6003;

short GetPortNumber(char* pBuf, const char* enableChannelName, const char* disableChannelName)
{
    while ( pBuf != NULL )
    {
        char* pDelim = strchr( pBuf, ':' );
        if ( pDelim != NULL )
        {
            *pDelim = '\0';
            char* pName = pBuf;
            char* pPort = pDelim + 1;

            short port = atoi( pPort );

            if ( (port > 6000) && strcmp( pName, enableChannelName ) == 0 )
            {
                return port;
            }
            else if ( (port > 6000) && strcmp( pName, disableChannelName ) == 0 )
            {
                return -1;
            }

            pBuf = pPort;

            while ( isdigit( *pBuf ) )
            {
                ++pBuf;
            }

            if ( pBuf == '\0' )
            {
                pBuf = NULL;
            }
        }
        else
        {
            pBuf = NULL;
        }
    }

    return -1;
}

NintendoWare::G3d::Edit::HtcResult^ SocketReceiveMessage(char* outBuffer, size_t bufferSize, nw::g3d::tool::Socket& socket)
{
    NintendoWare::G3d::Edit::HtcResult^ result;
    int bytesRecv = 0;

    // 一回目の接続で失敗した場合、1000回までは繰り返す。それ以降は失敗とみなす。
    for (int i = 0; i < 1000; ++i)
    {
        result = socket.Recv(&bytesRecv, outBuffer, static_cast<int>(bufferSize) - 1 );
        if (result->IsSuccess)
        {
            outBuffer[ bytesRecv ] = '\0';
            return result;
        }
    }

    return result;
}

} // anonymous namespace

namespace NintendoWare { namespace G3d { namespace Edit {

CafeCommDevice::CafeCommDevice(RecvInfo^ recvInfo)
    : CommDevice(6000, recvInfo, true)
{
}

CafeCommDevice::~CafeCommDevice()
{
}
CafeCommDevice::!CafeCommDevice()
{
}

NintendoWare::G3d::Edit::HtcResult^ CafeCommDevice::Connect()
{
    nw::g3d::tool::Socket cafeOpenSocket;
    NintendoWare::G3d::Edit::HtcResult^ result;

    result = cafeOpenSocket.Open();
    if (!result->IsSuccess)
    {
        return result;
    }

    result = cafeOpenSocket.Connect(CAFE_HIO_OPEN_PORT);
    if (!result->IsSuccess)
    {
        return result;
    }

    char recvBuffer[ 256 ];
    result = SocketReceiveMessage(recvBuffer, sizeof(recvBuffer), cafeOpenSocket);
    if (!result->IsSuccess)
    {
        return result;
    }

    short portNumber = GetPortNumber(recvBuffer, ENABLE_CHNNEL_NAME.c_str(), DISABLE_CHNNEL_NAME.c_str());
    if (portNumber < 0)
    {
        result->ResultCode = HtcResultCode::ValidEditPortNotFound;
        return result;
    }

    m_PortNumber = portNumber;

        if (m_IsConnected)
        {
            CloseConnection();
            OpenConnection();
        }

        result = m_Client->Connect(m_PortNumber);
    m_IsConnected = result->IsSuccess;
    return result;
}

NintendoWare::G3d::Edit::HtcResult^ CafeCommDevice::ConnectPing()
{
    nw::g3d::tool::Socket cafeOpenSocket;
    NintendoWare::G3d::Edit::HtcResult^ result;

    result = cafeOpenSocket.Open();
    if (!result->IsSuccess)
    {
        return result;
    }

    result = cafeOpenSocket.Connect(CAFE_HIO_OPEN_PORT);
    if (!result->IsSuccess)
        {
        return result;
        }

    char recvBuffer[ 256 ];
    result = SocketReceiveMessage(recvBuffer, sizeof(recvBuffer), cafeOpenSocket);
    if (!result->IsSuccess)
    {
        return result;
    }

    short portNumber = GetPortNumber(recvBuffer, ENABLE_PING_CHNNEL_NAME.c_str(), DISABLE_PING_CHNNEL_NAME.c_str());
    if (portNumber < 0)
    {
    result->ResultCode = HtcResultCode::ValidEditPortNotFound;
        return result;
    }

    m_PingPortNumber = portNumber;

    if (m_IsPingConnected)
    {
        ClosePingConnection();
        OpenPingConnection();
    }

    result = m_Client->ConnectPing(m_PingPortNumber);
    this->IsPingConnected = result->IsSuccess;
    return result;
}

}}} // namespace NintendoWare.G3d.Edit
