﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

// g3dhiolib.h

#pragma once

#include "G3dHioLibDefs.h"

#include "EditBinAnimCurve.h"
#include <nw/g3d/edit/detail/g3d_EditDetailDefs.h>
#include <nn/g3d/viewer/detail/g3d_ViewerPacketDefine.h>

namespace NintendoWare {
namespace G3d {
namespace Edit {

private ref class AnimCommandMaker abstract sealed
{
public:
    static bool CreateAnimCurve(nw::g3d::tool::EditBinAnimCurve* animCurve, UINT32 targetOffset, ICurve^ curve);

    static int CalcBindAnimationsPacketSize(array<UINT32>^ animationKeys);

    static int CalcEditAnimCurvePacketSize(nw::g3d::tool::EditBinAnimCurve* animCurve);

    static int CalcEditFrameCtrlPacketSize();
    static int CalcAnimEditInfoPacketSize();

    static bool MakeBindAnimationsPacket(
        array<System::Byte>^ packetBuffer,
        nw::g3d::edit::detail::CommandFlag command,
        UINT32 modelKey,
        array<UINT32>^ animationKeys,
        bool isAttachModel,
        TargetEndianKind endianKind);

    static bool MakeEditAnimCurvePacket(
        array<System::Byte>^ packetBuffer,
        nw::g3d::tool::EditBinAnimCurve* animCurve,
        nw::g3d::edit::detail::CommandFlag command,
        nw::g3d::edit::detail::EditTargetKind editTargetKind,
        UINT32 animationKey,
        UINT32 index,
        INT32 curveIndex,
        TargetEndianKind endianKind);

    static bool MakeEditFrameCtrlPacket(
        array<System::Byte>^ packetBuffer,
        nn::g3d::viewer::detail::CommandFlag command,
        float frame,
        float frameStep,
        nn::g3d::viewer::detail::EditPlayPolicyKind kind,
        float startFrame,
        float frameCount,
        TargetEndianKind endianKind);

    static bool MakeAnimEditInfoPacket(
        array<System::Byte>^ packetBuffer,
        UINT32 modelKey,
        UINT32 animationKey,
        nw::g3d::edit::detail::CommandFlag command,
        float value,
        TargetEndianKind endianKind);
};

}}} // namespace NintendoWare.G3d.Edit
