﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace NintendoWare.G3d.Edit
{
    public enum RenderInfoKind
    {
        String,
        Int,
        Float
    }

    public interface IRenderInfo : ICloneable
    {
        RenderInfoKind Kind
        {
            get;
        }

        string Name
        {
            get;
        }

        int ItemCount
        {
            get;
        }

        int ValueCount
        {
            get;
        }
    }

    public interface IRenderInfoItem : ICloneable
    {
        byte[] Alias { get; }
    }

    public interface IRenderInfoItem<T> : IRenderInfoItem
    {
        T Choice { get; }
    }

    public interface IRenderInfoValue : ICloneable
    {
    }

    public interface IRenderInfoValue<T> : IRenderInfoValue
    {
        T DefaultValue { get; }

        T EditedValue { get; }
    }

    public interface IRenderInfo<T> : IRenderInfo
    {
        IList<IRenderInfoItem<T>> Items
        {
            get;
        }

        IList<IRenderInfoValue<T>> Values { get; }
    }
}
