﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace NintendoWare.G3d.Edit.Math
{
    public class Vector4Base<T> : IVectorBase where T : struct
    {
        private readonly T[] values = new T[4];

        /// <summary>
        /// 次元数を取得します。
        /// </summary>
        public int Dimension
        {
            get
            {
                return 4;
            }
        }

        public T X
        {
            get
            {
                return this.values[0];
            }
            set { this.values[0] = value; }
        }
        public T Y
        {
            get
            {
                return this.values[1];
            }
            set { this.values[1] = value; }
        }
        public T Z
        {
            get
            {
                return this.values[2];
            }
            set { this.values[2] = value; }
        }
        public T W
        {
            get
            {
                return this.values[3];
            }
            set { this.values[3] = value; }
        }

        public T[] ToArray()
        {
            return this.values;
        }

        /// <summary>
        /// オブジェクトを設定します。
        /// </summary>
        /// <param name="source">設定するオブジェクトです。</param>
        public void Set(object source)
        {
            if (source is Vector4Base<T>)
            {
                this.Set(source as Vector4Base<T>);
            }
        }

        /// <summary>
        /// オブジェクトを設定します。
        /// </summary>
        /// <param name="source">設定するオブジェクトです。</param>
        public void Set(Vector4Base<T> source)
        {
            this.X = source.X;
            this.Y = source.Y;
            this.Z = source.Z;
            this.W = source.W;
        }

        /// <summary>
        /// X,Y,Z,W座標を指定の値に設定します。
        /// </summary>
        /// <param name="x">X座標です。</param>
        /// <param name="y">Y座標です。</param>
        /// <param name="z">Z座標です。</param>
        /// <param name="w">W座標です。</param>
        public void Set(T x, T y, T z, T w)
        {
            this.X = x;
            this.Y = y;
            this.Z = z;
            this.W = w;
        }
    }
}
