﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace NintendoWare.G3d.Edit.Math
{
    public class Vector3Base<T> : IVectorBase where T : struct
    {
        private readonly T[] values = new T[3];

        /// <summary>
        /// 次元数を取得します。
        /// </summary>
        public int Dimension
        {
            get
            {
                return 3;
            }
        }

        public T X
        {
            get
            {
                return this.values[0];
            }
            set { this.values[0] = value; }
        }
        public T Y
        {
            get
            {
                return this.values[1];
            }
            set { this.values[1] = value; }
        }
        public T Z
        {
            get
            {
                return this.values[2];
            }
            set { this.values[2] = value; }
        }
        public T[] ToArray()
        {
            return this.values;
        }

        /// <summary>
        /// オブジェクトを設定します。
        /// </summary>
        /// <param name="source">設定するオブジェクトです。</param>
        public void Set(object source)
        {
            if (source is Vector3Base<T>)
            {
                this.Set(source as Vector3Base<T>);
            }
        }

        /// <summary>
        /// オブジェクトを設定します。
        /// </summary>
        /// <param name="source">設定するオブジェクトです。</param>
        public void Set(Vector3Base<T> source)
        {
            this.X = source.X;
            this.Y = source.Y;
            this.Z = source.Z;
        }

        /// <summary>
        /// X,Y,Z座標を指定の値に設定します。
        /// </summary>
        /// <param name="x">X座標です。</param>
        /// <param name="y">Y座標です。</param>
        /// <param name="z">Z座標です。</param>
        public void Set(T x, T y, T z)
        {
            this.X = x;
            this.Y = y;
            this.Z = z;
        }
    }
}
