﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace NintendoWare.G3d.Edit.Math
{
    public sealed class Vector3 : Vector3Base<float>, IVector
    {
        /// <summary>
        /// デフォルトコンストラクタです。
        /// </summary>
        public Vector3()
        {
        }

        /// <summary>
        /// X,Y,Z座標を指定の値に設定するコンストラクタです。
        /// </summary>
        /// <param name="x">X座標です。</param>
        /// <param name="y">Y座標です。</param>
        /// <param name="z">Z座標です。</param>
        public Vector3(float x, float y, float z)
        {
            this.Set(x, y, z);
        }

        /// <summary>
        /// 指定したインデックス位置の成分を取得、または設定します。
        /// </summary>
        /// <param name="i">インデックスです。</param>
        /// <returns>成分です。</returns>
        public float this[int i]
        {
            get
            {
                switch (i)
                {
                    case 0:
                        return this.X;
                    case 1:
                        return this.Y;
                    case 2:
                        return this.Z;
                    default:
                        throw new ArgumentOutOfRangeException();
                }
            }

            set
            {
                switch (i)
                {
                    case 0:
                        this.X = value;
                        break;
                    case 1:
                        this.Y = value;
                        break;
                    case 2:
                        this.Z = value;
                        break;
                    default:
                        throw new ArgumentOutOfRangeException();
                }
            }
        }

        /// <summary>
        /// X,Y,Z座標を格納した配列を返します。
        /// </summary>
        /// <returns>X,Y,Z座標の配列です。</returns>
        float[] IVector.ToArray()
        {
            return this.ToArray();
        }
    }

    public sealed class Vector3i : Vector3Base<int>
    {
    }

    public sealed class Vector3u : Vector3Base<uint>
    {
    }
    public sealed class Vector3b : Vector3Base<bool>
    {
    }
}
