﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace NintendoWare.G3d.Edit.Math
{
    public class TextureSRT2D
    {
        private readonly Vector2 scale = new Vector2();
        private float rotate;
        private readonly Vector2 trans = new Vector2();
        private SRTKind kind = SRTKind.SRTNormal;

        public enum SRTKind
        {
            SRTNormal,
            SRTMaya,
            SRT3DSMax,
            SRTSoftimage
        }

        public SRTKind Kind
        {
            get { return this.kind; }
            set { this.kind = value; }
        }

        public Vector2 Scale
        {
            get { return this.scale; }
        }

        public float Rotate
        {
            get { return this.rotate; }
            set { this.rotate = value; }
        }

        public Vector2 Trans
        {
            get { return this.trans; }
        }

        /// <summary>
        /// 要素を格納した配列を返します。
        /// </summary>
        /// <returns>要素の配列です。</returns>
        public float[] ToArray()
        {
            float[] scale = this.scale.ToArray();
            float[] trans = this.trans.ToArray();

            return new float[]
            {
                scale[0], scale[1],
                this.rotate,
                trans[0], trans[1]
            };
        }
    }
}
