﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace NintendoWare.G3d.Edit
{
    public static class RenderState
    {
        public enum Mode
        {
            Custom,
            Opaque,
            Mask,
            Translucent
        }

        public enum BlendMode
        {
            None,
            Color,
            Logic
        }

        public enum DepthTestFuncKind
        {
            Never,
            Less,
            Equal,
            LessEqual,
            Greater,
            NotEqual,
            GreaterEqual,
            Always,
        }

        public enum AlphaTestFuncKind
        {
            Never,
            Less,
            Equal,
            LessEqual,
            Greater,
            NotEqual,
            GreaterEqual,
            Always,
        }

        public enum LogicOpKind
        {
            Clear,
            Set,
            Copy,
            InvCopy,
            NoOp,
            Inv,
            And,
            NotAnd,
            Or,
            NotOr,
            XOr,
            Equiv,
            RevAnd,
            InvAnd,
            RevOr,
            InvOr,
        }

        public enum BlendCombineKind
        {
            Add,
            SrcMinusDst,
            Min,
            Max,
            DstMinusSrc,
        }

        public enum ColorBlendFuncKind
        {
            Zero,
            One,
            SrcColor,
            OneMinusSrcColor,
            SrcAlpha,
            OneMinusSrcAlpha,
            DstAlpha,
            OneMinusDstAlpha,
            DstColor,
            OneMinusDstColor,
            SrcAlphaSaturate,
            ConstantColor,
            OneMinusConstantColor,
            Src1Color,
            OneMinusSrc1Color,
            Src1Alpha,
            OneMinusSrc1Alpha,
            ConstantAlpha,
            OneMinusConstantAlpha,
        }

        public enum AlphaBlendFuncKind
        {
            Zero,
            One,
            SrcAlpha,
            OneMinusSrcAlpha,
            DstAlpha,
            OneMinusDstAlpha,
            SrcAlphaSaturate,
            Src1Alpha,
            OneMinusSrc1Alpha,
            ConstantAlpha,
            OneMinusConstantAlpha,
        }
    }
}
