﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace NintendoWare.G3d.Edit
{
    public abstract class Command : ICommand
    {
        private uint numberOfTrials = 0;
        private readonly TargetEndianKind targetEndian;
        protected Command(TargetEndianKind targetEndian)
        {
            this.targetEndian = targetEndian;
        }

        /// <summary>
        /// コマンドが処理できるか判定します。
        /// </summary>
        public bool CanProcess()
        {
            ++this.numberOfTrials;
            return CanProcessImpl();
        }

        public TargetEndianKind TargetEndian
        {
            get
            {
                return this.targetEndian;
            }
        }

        /// <summary>
        /// コマンドの試行回数を取得します。
        /// </summary>
        public uint NumberOfTrials
        {
            get
            {
                return this.numberOfTrials;
            }
        }

        /// <summary>
        /// コマンド追加順である必要があるか判定します。
        /// </summary>
        public virtual bool IsInOrder
        {
            get
            {
                return false;
            }
        }

        public virtual void OnRemoved()
        {
        }

        protected virtual bool CanProcessImpl()
        {
            return true;
        }
    }
}
