﻿using System;
using System.Collections;
using System.Globalization;
using System.Threading;
using System.Windows.Data;
using System.Windows.Markup;
using System.Windows.Threading;

namespace Nintendo.InGameEditing.WPF
{
    /// <summary>
    /// 変換対象が IEnumerable である場合に BindingOperations.EnableCollectionSynchronization によるロックをかけます。
    /// コンバータのインスタンスは UI スレッドから生成されることを前提とします。
    /// </summary>
    internal class SynchronizeCollectionFilter : MarkupExtension, IValueConverter
    {
        private static IValueConverter instance;
        private static Dispatcher uiDispatcher;

        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            var enumerable = value as IEnumerable;
            if (enumerable != null)
            {
                uiDispatcher.Invoke(() => BindingOperations.EnableCollectionSynchronization(enumerable, this));
            }

            return value;
        }

        public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
        {
            throw new NotSupportedException();
        }

        public override object ProvideValue(IServiceProvider serviceProvider)
        {
            Interlocked.CompareExchange(ref uiDispatcher, Dispatcher.CurrentDispatcher, null);
            return instance ?? (instance = new SynchronizeCollectionFilter());
        }
    }
}
