﻿using System.IO;

namespace Nintendo.InGameEditing
{
    /// <summary>
    /// 特定の型に対するシリアライズ・デシリアライズを行うインターフェースです。
    /// </summary>
    /// <typeparam name="T">対象の型</typeparam>
    public interface ITypeSerializer<T>
    {
        /// <summary>
        /// 値をバイト列表現にシリアライズします。
        /// </summary>
        /// <param name="value">シリアライズする値</param>
        /// <returns>シリアライズ結果</returns>
        byte[] Serialize(T value);

        /// <summary>
        /// バイト列を値にデシリアライズします。
        /// </summary>
        /// <param name="data">値のバイト列表現</param>
        /// <returns>デシリアライズ結果</returns>
        T Deserialize(byte[] data);
    }
}
