﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Xml.Linq;

namespace Nintendo.InGameEditing.Communication.Htcs
{
    internal class RegisterPortMapCommand
    {
        public PortMapItem PortMapItem { get; }
        public string RequestName { get; }

        public RegisterPortMapCommand(PortMapItem portMapItem, string requestName = "")
        {
            this.PortMapItem = portMapItem;
            this.RequestName = requestName;
        }

        public const string XElementName = "RegisterPortMapCommand";

        public RegisterPortMapCommand(XElement xElement)
        {
            this.PortMapItem = new PortMapItem(xElement.Element(PortMapItem.XElementName));
            XElement req = xElement.Element("RequestName");
            this.RequestName = req?.Value ?? string.Empty;
        }

        public XElement ToXElement()
        {
            return new XElement(XElementName, PortMapItem.ToXElement(), new XElement("RequestName", RequestName));
        }
    }

    internal class UnregisterPortMapCommand
    {
        public HtcsPortDescriptor HtcsPortDescriptor { get; }
        public string RequestName { get; private set; }

        public UnregisterPortMapCommand(HtcsPortDescriptor htcsPortDescriptor, string requestName = "")
        {
            this.HtcsPortDescriptor = htcsPortDescriptor;
            this.RequestName = requestName;
        }

        public const string XElementName = "UnregisterPortMapCommand";

        public UnregisterPortMapCommand(XElement xElement)
        {
            PortMapItem portMapItem = new PortMapItem(xElement.Element(PortMapItem.XElementName));
            this.HtcsPortDescriptor = portMapItem.HtcsPortDescriptor;
            XElement req = xElement.Element("RequestName");
            this.RequestName = req?.Value ?? string.Empty;
        }

        public XElement ToXElement()
        {
            return new XElement(XElementName,
                new XElement(HtcsPeerName.XElementName, HtcsPortDescriptor.HtcsPeerName),
                new XElement("HtcsPortName", HtcsPortDescriptor.HtcsPortName));
        }
    }
}
