﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include "Util.h"

namespace gfxutil
{


class GfxContext;
class FontRenderer;

//! @brief      ラベルを表します
class Label
{
public:
    enum DrawAlign
    {
        DrawAlign_Left,     //  指定した位置に対して左側に描画します
        DrawAlign_Center,   //  指定した位置を中心に描画します
        DrawAlign_Right,    //  指定した位置に対して右側に描画します
    };

public:
    //! @brief  コンストラクタです
    explicit Label() NN_NOEXCEPT;
    //! @brief  描画します
    void Draw(GfxContext& gfxContext) NN_NOEXCEPT;

    //! @brief  テキストを取得します
    const char* GetText() const NN_NOEXCEPT;
    //! @brief  位置を取得します
    const nn::util::Float2& GetPosition() const NN_NOEXCEPT;
    //! @brief  描画されるサイズを計算します
    const nn::util::Float2 CalculateDrawSize(FontRenderer& fontRenderer) NN_NOEXCEPT;

    //! @brief  テキストを設定します
    void SetText(const char* text, ...) NN_NOEXCEPT;
    //! @brief  テキストの描画位置を設定します
    void SetDrawAlign(DrawAlign align) NN_NOEXCEPT;
    //! @brief  テキストのスケールを設定します
    void SetScale(float scaleX, float scaleY) NN_NOEXCEPT;
    //! @brief  描画される幅を設定します
    void SetDrawWidth(float width) NN_NOEXCEPT;

    //! @brief  位置を設定します
    void SetPosition(float x, float y) NN_NOEXCEPT;
    //! @brief  枠の大きさを設定します
    void SetEdgeSize(float size) NN_NOEXCEPT;

    //! @brief  テキストの色を設定します
    void SetColor(const nn::util::Unorm8x4& color) NN_NOEXCEPT;
    //! @brief  背景の色を設定します
    void SetBackColor(const nn::util::Uint8x4& color) NN_NOEXCEPT;
    //! @brief  枠の色を設定します
    void SetEdgeColor(const nn::util::Uint8x4& color) NN_NOEXCEPT;

private:
    //  テキストの最大の長さ
    static const int TextLengthMax = 128;

private:
    //! @brief  テキストの色を設定します
    bool IsTextSizeFixed();

private:
    char             m_Text[TextLengthMax];
    nn::util::Float2 m_DrawSize;
    nn::util::Float2 m_TextScale;

    bool             m_IsSizeChanged;
    bool             m_IsWidthFixed;

    nn::util::Float2 m_Position;
    float            m_EdgeSize;
    DrawAlign        m_DrawAlign;

    nn::util::Unorm8x4 m_Color;
    nn::util::Uint8x4  m_BackColor;
    nn::util::Uint8x4  m_EdgeColor;
};


}
