﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Assert.h>
#include "gfxutil/Label.h"
#include "HidPad.h"

//! @brief  項目名とその値による項目のリストです
class SelectItemListImpl
{
public:
    //! @brief  コンストラクタです
    SelectItemListImpl(int itemCount, gfxutil::Label* pNameLabel, gfxutil::Label* pValueLabel);

    //! @brief  初期化します
    void Initialize(float sizeX) NN_NOEXCEPT;
    //! @brief  入力による更新を行います
    void UpdateByHid(const HidPad& hidPad) NN_NOEXCEPT;
    //! @brief  描画します
    void Draw(gfxutil::GfxContext& gfxContext, float positionX, float positionY) NN_NOEXCEPT;

    //! @brief  フォーカスを設定します
    void SetFocused(bool isFocused) NN_NOEXCEPT;
    //! @brief  選択中の項目 index を返します
    int GetSelectedItemIndex() const NN_NOEXCEPT;
    //! @brief  選択中の項目 index を設定します
    void SetSelectedItemIndex(int index) NN_NOEXCEPT;
    //! @brief  index 番目の項目の名前ラベルを取得します
    gfxutil::Label& GetNameLabel(int index) NN_NOEXCEPT;
    //! @brief  index 番目の項目の値ラベルを取得します
    gfxutil::Label& GetValueLabel(int index) NN_NOEXCEPT;

private:
    gfxutil::Label* m_pName;
    gfxutil::Label* m_pValue;

    const int m_ItemCount;
    float m_SizeX;

    int m_Current;
    bool m_isFocused;
};


//! @brief  項目名とその値による項目のリストです
template <int ItemCount>
class SelectItemList : public SelectItemListImpl
{
public:
    //! @brief  コンストラクタです
    SelectItemList()
        : SelectItemListImpl( ItemCount, m_Name, m_Value )
    {}

private:
    gfxutil::Label m_Name[ItemCount];
    gfxutil::Label m_Value[ItemCount];
};
