﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/vfx/vfx_RenderContext.h>

namespace nn {
namespace vfx {
namespace detail {

//---------------------------------------------------------------------------
//! @brief  初期化
//---------------------------------------------------------------------------
void Rendercontext::Initialize( nn::gfx::Device* device, ResRenderState* resRenderState ) NN_NOEXCEPT
{
    // TODO : アルファテスト
    //        ピクセルシェーダで実装？？
    // resRenderState->isAlphaTest
    // resRenderState->alphaThreshold
    // resRenderState->alphaFunc
    // glEnable(  GL_ALPHA_TEST );
    // glAlphaFunc( GL_GREATER, alphaThreshold );
    // switch ( func )
    // {
    // case nn::vfx::VFX_COMPARE_NEVER:   glAlphaFunc( GL_NEVER,    alphaThreshold ); break;
    // case nn::vfx::VFX_COMPARE_LESS:    glAlphaFunc( GL_LESS,     alphaThreshold ); break;
    // case nn::vfx::VFX_COMPARE_EQUAL:   glAlphaFunc( GL_EQUAL,    alphaThreshold ); break;
    // case nn::vfx::VFX_COMPARE_LEQUAL:  glAlphaFunc( GL_LEQUAL,   alphaThreshold ); break;
    // case nn::vfx::VFX_COMPARE_GREATER: glAlphaFunc( GL_GREATER,  alphaThreshold ); break;
    // case nn::vfx::VFX_COMPARE_NOTEQUAL:glAlphaFunc( GL_NOTEQUAL, alphaThreshold ); break;
    // case nn::vfx::VFX_COMPARE_GEQUAL:  glAlphaFunc( GL_GEQUAL,   alphaThreshold ); break;
    // case nn::vfx::VFX_COMPARE_ALWAYS:  glAlphaFunc( GL_ALWAYS,   alphaThreshold ); break;
    // default: break;
    // }

    m_pResRenderState = resRenderState;

    {
        nn::gfx::BlendState::InfoType info;
        info.SetDefault();
        nn::gfx::BlendTargetStateInfo targetInfo;
        {
            targetInfo.SetDefault();

            targetInfo.SetBlendEnabled( ( m_pResRenderState->isBlendEnable != 0 ) );

            switch( m_pResRenderState->blendType )
            {
            case BlendType_Normal:
                targetInfo.SetSourceColorBlendFactor( nn::gfx::BlendFactor_SourceAlpha );
                targetInfo.SetDestinationColorBlendFactor( nn::gfx::BlendFactor_OneMinusSourceAlpha );
                targetInfo.SetColorBlendFunction( nn::gfx::BlendFunction_Add );
                targetInfo.SetSourceAlphaBlendFactor( nn::gfx::BlendFactor_SourceAlpha );
                targetInfo.SetDestinationAlphaBlendFactor( nn::gfx::BlendFactor_OneMinusSourceAlpha );
                targetInfo.SetAlphaBlendFunction( nn::gfx::BlendFunction_Add );
                break;

            case BlendType_Add:
                targetInfo.SetSourceColorBlendFactor( nn::gfx::BlendFactor_SourceAlpha );
                targetInfo.SetDestinationColorBlendFactor( nn::gfx::BlendFactor_One );
                targetInfo.SetColorBlendFunction( nn::gfx::BlendFunction_Add );
                targetInfo.SetSourceAlphaBlendFactor( nn::gfx::BlendFactor_SourceAlpha );
                targetInfo.SetDestinationAlphaBlendFactor( nn::gfx::BlendFactor_One );
                targetInfo.SetAlphaBlendFunction( nn::gfx::BlendFunction_Add );
                break;

            case BlendType_Sub:
                targetInfo.SetSourceColorBlendFactor( nn::gfx::BlendFactor_SourceAlpha );
                targetInfo.SetDestinationColorBlendFactor( nn::gfx::BlendFactor_One );
                targetInfo.SetColorBlendFunction( nn::gfx::BlendFunction_ReverseSubtract );
                targetInfo.SetSourceAlphaBlendFactor( nn::gfx::BlendFactor_SourceAlpha );
                targetInfo.SetDestinationAlphaBlendFactor( nn::gfx::BlendFactor_One );
                targetInfo.SetAlphaBlendFunction( nn::gfx::BlendFunction_ReverseSubtract );
                break;

            case BlendType_Screen:
                targetInfo.SetSourceColorBlendFactor( nn::gfx::BlendFactor_OneMinusDestinationColor );
                targetInfo.SetDestinationColorBlendFactor( nn::gfx::BlendFactor_One );
                targetInfo.SetColorBlendFunction( nn::gfx::BlendFunction_Add );
                targetInfo.SetSourceAlphaBlendFactor( nn::gfx::BlendFactor_OneMinusDestinationColor );
                targetInfo.SetDestinationAlphaBlendFactor( nn::gfx::BlendFactor_One );
                targetInfo.SetAlphaBlendFunction( nn::gfx::BlendFunction_Add );
                break;

            case BlendType_Multiply:
                targetInfo.SetSourceColorBlendFactor( nn::gfx::BlendFactor_Zero );
                targetInfo.SetDestinationColorBlendFactor( nn::gfx::BlendFactor_SourceColor );
                targetInfo.SetColorBlendFunction( nn::gfx::BlendFunction_Add );
                targetInfo.SetSourceAlphaBlendFactor( nn::gfx::BlendFactor_Zero );
                targetInfo.SetDestinationAlphaBlendFactor( nn::gfx::BlendFactor_SourceColor );
                targetInfo.SetAlphaBlendFunction( nn::gfx::BlendFunction_Add );
                break;

            case BlendType_PreMultipliedAlpha:
                targetInfo.SetSourceColorBlendFactor( nn::gfx::BlendFactor_One );
                targetInfo.SetDestinationColorBlendFactor( nn::gfx::BlendFactor_OneMinusSourceAlpha );
                targetInfo.SetColorBlendFunction( nn::gfx::BlendFunction_Add );
                targetInfo.SetSourceAlphaBlendFactor( nn::gfx::BlendFactor_One );
                targetInfo.SetDestinationAlphaBlendFactor( nn::gfx::BlendFactor_OneMinusSourceAlpha );
                targetInfo.SetAlphaBlendFunction( nn::gfx::BlendFunction_Add );
                break;
            default:
                break;
            }
        };

        info.SetIndependentBlendEnabled( false );
        info.SetBlendTargetStateInfoArray( &targetInfo, 1 );

        size_t memorySize = nn::gfx::BlendState::GetRequiredMemorySize( info );
        NN_SDK_ASSERT( memorySize < static_cast<size_t>( RequiredMemorySize_BlendState ) );
        m_BlendState.SetMemory( &m_BlendStateBuffer, memorySize );
        m_BlendState.Initialize( device, info );
    }

    {
        nn::gfx::DepthStencilState::InfoType info;
        info.SetDefault();
        info.SetDepthTestEnabled( resRenderState->isDepthTest != 0 );
        info.SetDepthWriteEnabled( resRenderState->isDepthMask != 0 );

        switch( m_pResRenderState->depthFunc )
        {
        case nn::vfx::detail::TestCompareFunction_Never:   info.SetDepthComparisonFunction( nn::gfx::ComparisonFunction_Never );        break;
        case nn::vfx::detail::TestCompareFunction_Less:    info.SetDepthComparisonFunction( nn::gfx::ComparisonFunction_Less );         break;
        case nn::vfx::detail::TestCompareFunction_Equal:   info.SetDepthComparisonFunction( nn::gfx::ComparisonFunction_Equal );        break;
        case nn::vfx::detail::TestCompareFunction_LessOrEqual:  info.SetDepthComparisonFunction( nn::gfx::ComparisonFunction_LessEqual );    break;
        case nn::vfx::detail::TestCompareFunction_GreaterThan: info.SetDepthComparisonFunction( nn::gfx::ComparisonFunction_Greater );      break;
        case nn::vfx::detail::TestCompareFunction_NotEqual:info.SetDepthComparisonFunction( nn::gfx::ComparisonFunction_NotEqual );     break;
        case nn::vfx::detail::TestCompareFunction_GreaterOrEqual:  info.SetDepthComparisonFunction( nn::gfx::ComparisonFunction_GreaterEqual ); break;
        case nn::vfx::detail::TestCompareFunction_Always:  info.SetDepthComparisonFunction( nn::gfx::ComparisonFunction_Always );       break;
        default: break;
        }
        m_DepthStencilState.Initialize( device, info );
    }

    {
        nn::gfx::RasterizerState::InfoType info;
        info.SetDefault();
        info.SetCullMode( nn::gfx::CullMode_None );

        switch( m_pResRenderState->displaySide )
        {
        case DisplaySideType_Both:  info.SetCullMode( nn::gfx::CullMode_None ); break;
        case DisplaySideType_Front: info.SetCullMode( nn::gfx::CullMode_Back ); break;
        case DisplaySideType_Back:  info.SetCullMode( nn::gfx::CullMode_Front ); break;
        default: break;
        }

        info.SetScissorEnabled( true );
        info.SetDepthClipEnabled( true );
        m_RasterizerState.Initialize( device, info );
    }
}// NOLINT(readability/fn_size)

//---------------------------------------------------------------------------
//! @brief  終了処理
//---------------------------------------------------------------------------
void Rendercontext::Finalize( nn::gfx::Device* device ) NN_NOEXCEPT
{
    m_BlendState.Finalize( device );
    m_DepthStencilState.Finalize( device );
    m_RasterizerState.Finalize( device );
}

} // namespace detail
} // namespace vfx
} // namespace nn

