﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ui2d/ui2d_Parts.h>
#include <nn/ui2d/ui2d_Material.h>

namespace nn
{
namespace ui2d
{

Parts::Parts()
: Base()
, m_pLayout(NULL)
{
}

Parts::Parts(
        const ResParts* pBaseBlock,
        const ResParts* pOverrideBlock,
        const BuildArgSet& buildArgSet
)
: Base(NULL, NULL, pBaseBlock, buildArgSet)
, m_pLayout(NULL)
{
    NN_UNUSED(pOverrideBlock);
}

Parts::Parts(const Parts& parts)
: Base(parts)
, m_pLayout(NULL)
{
}

Parts::~Parts()
{
    // OSReport("Parts::~Parts()\n");
}

Pane*
Parts::FindPaneByNameRecursive(const char* pFindName)
{
    if (detail::EqualsResName(GetName(), pFindName)) {
        return this;
    } else {
        return NULL;
    }

}

const Pane*
Parts::FindPaneByNameRecursive(const char* pFindName) const
{
    return const_cast<Parts*>(this)->FindPaneByNameRecursive(pFindName);
}

Material*
Parts::FindMaterialByNameRecursive(const char* pFindName)
{
    uint32_t  nbMaterial = GetMaterialCount();
    for (uint32_t  idx = 0; idx < nbMaterial; ++idx)
    {
        Material* pMaterial = GetMaterial(idx);
        if (pMaterial)
        {
            if (detail::EqualsMaterialName(pMaterial->GetName(), pFindName))
            {
                return pMaterial;
            }
        }
    }

    return NULL;
}

const Material*
    Parts::FindMaterialByNameRecursive(const char* pFindName) const
{
    return const_cast<Parts*>(this)->FindMaterialByNameRecursive(pFindName);
}

bool
Parts::CompareCopiedInstanceTest(const Parts& target) const
{
    NN_UNUSED(target);
    // パーツペインのコピーコンストラクタでは何もコピーされない。
    return true;
}

} // namespace nn::ui2d
} // namespace nn
