﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "precompiled.h"

#ifdef NN_BUILD_CONFIG_SPY_ENABLED

#include <nn/diag/text/diag_SdkTextSpy.h>

#include <nn/spy/detail/fnd/string/spyfnd_String.h>
#include <nn/spy/spy_PlotModule.h>
#include <nn/spy/spy_PlotNode.h>

namespace nn {
namespace spy {

//------------------------------------------------------------------------------
PlotNode::PlotNode() NN_NOEXCEPT
{
    InitializePacketCommonData();
}

//------------------------------------------------------------------------------
PlotNode::PlotNode(const char* name) NN_NOEXCEPT
{
    InitializePacketCommonData();
    SetName(name);
}

//------------------------------------------------------------------------------
PlotNode::~PlotNode() NN_NOEXCEPT
{
}

//------------------------------------------------------------------------------
void PlotNode::InitializePacketCommonData() NN_NOEXCEPT
{
    std::memset(&m_MetadataPacketPayload, 0, sizeof(m_MetadataPacketPayload));
    InitializeItemMetaData(&m_MetadataPacketPayload.itemMetaData);
    m_MetadataPacketPayload.common.dataType = nn::spy::detail::SpyPlotItemPacket::DataType_NodeMetadata;
}

//------------------------------------------------------------------------------
void PlotNode::SetParent(PlotNode* pNode) NN_NOEXCEPT
{
    NN_DETAIL_SPY_WARN(NN_TEXT_SPY("[%s] spy::PlotNode への親ノードの設定はまだできません。\n"), NN_CURRENT_FUNCTION_NAME);
    NN_UNUSED(pNode);
}

//------------------------------------------------------------------------------
void PlotNode::PushOwnMetaData() NN_NOEXCEPT
{
    if(!PushData(m_MetadataPacketPayload))
    {
        NN_DETAIL_SPY_WARN(NN_TEXT_SPY("[%s] spy::PlotNode '%s' のメタデータ送信に失敗しました。\n"), NN_CURRENT_FUNCTION_NAME, GetName());
    }
}

//------------------------------------------------------------------------------
void PlotNode::PushDetachPacket() NN_NOEXCEPT
{
    NN_SDK_ASSERT(IsAttached());

    if (!IsRequested())
    {
        return;
    }

    if (!IsMetadataPushed())
    {
        return;
    }

    nn::spy::detail::SpyPlotItemPacket::NodeDetachPacketPayload payload;
    std::memset(&payload, 0, sizeof(payload));
    payload.common.dataType = nn::spy::detail::SpyPlotItemPacket::DataType_NodeDetach;
    payload.id = m_MetadataPacketPayload.itemMetaData.id;

    if(!PushData(payload))
    {
        NN_DETAIL_SPY_WARN(NN_TEXT_SPY("[%s] spy::PlotNode '%s' のデータ送信に失敗しました。\n"), NN_CURRENT_FUNCTION_NAME, GetName());
    }
}

} // namespace nn::spy
} // namespace nn

#endif // NN_BUILD_CONFIG_SPY_ENABLED
