﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>

#include <nn/ige/ige_GroupBox.h>

namespace nn { namespace ige {

GroupBox::GroupBox(detail::IgeAllocator* pAllocator, GroupBoxOption option) NN_NOEXCEPT
    : Control(&m_Node, option)
    , ControlFactory()
{
    NodeOption nodeOption;
    nodeOption.pUserData = this;
    nodeOption.pMetadataFunction = GenerateMetadata;
    nodeOption.enableAutoNotify = true;

    m_Node.Initialize(nodeOption);
    InitializeFactory(pAllocator, &m_Node);
}

GroupBox::~GroupBox() NN_NOEXCEPT
{
    DeleteAll();
}

void GroupBox::GenerateMetadata(BufferWriter* pWriter, const Node& node) NN_NOEXCEPT
{
    auto& self = *node.GetUserData<GroupBox>();
    WriteAttribute(pWriter, "type", "GroupBox");
    self.WriteCommonMetadata(pWriter);
}

}} // namespace nn::ige
