﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>

#include <nn/ige/ige_BufferWriter.h>
#include <nn/ige/ige_CheckBox.h>

namespace nn { namespace ige {

CheckBox::CheckBox(bool* pIsChecked, CheckBoxOption option) NN_NOEXCEPT
    : Control(&m_Node, option)
{
    NN_SDK_REQUIRES_NOT_NULL(pIsChecked);

    NodeOption nodeOption;
    nodeOption.pMetadataFunction = GenerateMetadata;
    nodeOption.pUserData = this;
    nodeOption.enableAutoNotify = false;

    m_Node.Initialize(pIsChecked, nodeOption);
}

void CheckBox::GenerateMetadata(BufferWriter* pWriter, const Node& node) NN_NOEXCEPT
{
    auto& self = *node.GetUserData<CheckBox>();
    WriteAttribute(pWriter, "type", "CheckBox");
    self.WriteCommonMetadata(pWriter);
}

}} // namespace nn::ige
