﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>

#include <nn/ige/ige_BufferWriter.h>
#include <nn/ige/ige_Button.h>

namespace nn { namespace ige {

Button::Button(ButtonOption option) NN_NOEXCEPT
    : Control(&m_Node, option)
    , m_pCallback(option.pClickCallback)
    , m_pUserData(option.pUserData)
{
    NodeOption nodeOption;
    nodeOption.pUserData = this;
    nodeOption.pMetadataFunction = GenerateMetadata;
    nodeOption.enableAutoNotify = false;

    m_Node.Initialize(Button::OnClicked, nodeOption);
}

void Button::GenerateMetadata(BufferWriter* pWriter, const Node& node) NN_NOEXCEPT
{
    auto& self = *node.GetUserData<Button>();
    WriteAttribute(pWriter, "type", "Button");
    self.WriteCommonMetadata(pWriter);
}

void Button::OnClicked(const BufferView&, const CommandNode& node) NN_NOEXCEPT
{
    auto& self = *node.GetUserData<Button>();
    if (self.m_pCallback)
    {
        self.m_pCallback(self.m_pUserData);
    }
}

}} // namespace nn::ige
