﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/os/os_Mutex.h>
#include "ige_ServerSocket.h"

namespace nn { namespace ige { namespace detail {

class ServerSocketHtcs : public ServerSocket
{
    NN_DISALLOW_COPY(ServerSocketHtcs) NN_NOEXCEPT;
public:
    ServerSocketHtcs() NN_NOEXCEPT;
    virtual bool IsConnected() const NN_NOEXCEPT NN_OVERRIDE;

private:
    virtual bool InitializeInternal(const SetupArg& arg) NN_NOEXCEPT NN_OVERRIDE;

    virtual bool OpenInternal() NN_NOEXCEPT NN_OVERRIDE;
    virtual void CloseInternal() NN_NOEXCEPT NN_OVERRIDE;

    virtual bool WriteAsyncInternal(const void* buf, size_t size) NN_NOEXCEPT NN_OVERRIDE;
    virtual bool WriteAsyncForPoll() NN_NOEXCEPT NN_OVERRIDE;

    virtual bool ReadAsyncInternal(void* buf, size_t size) NN_NOEXCEPT NN_OVERRIDE;
    virtual bool ReadAsyncForPoll() NN_NOEXCEPT NN_OVERRIDE;

    virtual void PollInternal() NN_NOEXCEPT NN_OVERRIDE;

    void CloseSocket() NN_NOEXCEPT;
    void CloseClientSocket() NN_NOEXCEPT;

private:
    int m_ServerDescriptor;
    int m_ClientDescriptor;

    static const int CHANNEL_NAME_LENGTH = 32;
    char        m_ChannelName[CHANNEL_NAME_LENGTH];
    nn::os::Mutex m_WriteMutex;
    nn::os::Mutex m_ReadMutex;
};

}}} // namespace nn::ige::detail
