﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/g3d/viewer/g3d_ViewerDefine.h>
#include "../g3d_ViewerDetailDefine.h"
#include "../g3d_CallbackCaller.h"
#include <nn/g3d/viewer/detail/g3d_ViewerPacketDefine.h>
#include <nn/gfx/gfx_Core.h>
#include <nn/gfx/gfx_Types.h>

namespace nn { namespace gfx {
    class ResTexture;
}}

namespace nn { namespace g3d {

    class ModelObj;
    class ResModel;
    class ResFile;
    class ResMaterialAnim;
    struct ResAnimCurveData;
    class MaterialAnimObj;

    namespace viewer { namespace detail {

        class Allocator;

        const char* GetEditCommandString(nn::g3d::viewer::detail::CommandFlag command) NN_NOEXCEPT;
        const char* GetResName(nn::g3d::ResFile* pResFile, nn::g3d::viewer::detail::FileDataKind kind) NN_NOEXCEPT;
        const char* GetFileDataKindString(nn::g3d::viewer::detail::FileDataKind kind) NN_NOEXCEPT;
        const char* GetAnimKindString(nn::g3d::viewer::detail::ViewerAnimKind kind) NN_NOEXCEPT;
        nn::g3d::viewer::detail::FileDataKind ConvertToFileDataKind(nn::g3d::viewer::detail::ViewerAnimKind kind) NN_NOEXCEPT;

        bool HasShaderParamAnim(nn::g3d::ResFile* pResFile) NN_NOEXCEPT;
        bool HasTexturePatternAnim(nn::g3d::ResFile* pResFile) NN_NOEXCEPT;
        bool HasMaterialVisibilityAnim(nn::g3d::ResFile* pResFile) NN_NOEXCEPT;

        const char* GetEditCommandString(nn::g3d::viewer::detail::CommandFlag command) NN_NOEXCEPT;

        void BindTexture(
            nn::g3d::ResFile* pBindDestinationResFile,
            nn::gfx::ResTextureFile* pResTextureFile,
            nn::g3d::viewer::detail::CallbackCaller& callback) NN_NOEXCEPT;

        void ForceBindTexture(
            nn::g3d::ResFile* pBindDestinationResFile,
            const nn::gfx::ResTextureFile* pResTextureFile,
            nn::g3d::viewer::detail::CallbackCaller& callback) NN_NOEXCEPT;

        void ForceBindTexture(
            nn::g3d::ResModel* pBindDestinationResModel,
            const nn::gfx::ResTextureFile* pResTextureFile,
            nn::g3d::viewer::detail::CallbackCaller& callback) NN_NOEXCEPT;
        void ForceUnbindTexture(
            nn::g3d::ResModel* pResModel,
            const nn::gfx::ResTextureFile* pResTextureFile,
            nn::g3d::viewer::detail::CallbackCaller& callback) NN_NOEXCEPT;

        void ForceBindTexture(
            nn::g3d::ModelObj* pModelObj,
            const nn::gfx::ResTextureFile* pResTextureFile,
            nn::g3d::viewer::detail::CallbackCaller& callback) NN_NOEXCEPT;
        void ForceUnbindTexture(
            nn::g3d::ModelObj* pModelObj,
            const nn::gfx::ResTextureFile* pResTextureFile,
            nn::g3d::viewer::detail::CallbackCaller& callback) NN_NOEXCEPT;

        void ForceBindTexture(
            nn::g3d::ResMaterialAnim* pBindDestinationResAnim,
            const nn::gfx::ResTextureFile* pResTextureFile,
            nn::g3d::viewer::detail::CallbackCaller& callback) NN_NOEXCEPT;
        void ForceUnbindTexture(
            nn::g3d::ResMaterialAnim* pResAnim,
            const nn::gfx::ResTextureFile* pResTextureFile,
            nn::g3d::viewer::detail::CallbackCaller& callback) NN_NOEXCEPT;

        void ForceBindTexture(
            nn::g3d::MaterialAnimObj* pMaterialAnimObj,
            const nn::gfx::ResTextureFile* pResTextureFile,
            nn::g3d::viewer::detail::CallbackCaller& callback) NN_NOEXCEPT;
        void ForceUnbindTexture(
            nn::g3d::MaterialAnimObj* pMaterialAnimObj,
            const nn::gfx::ResTextureFile* pResTextureFile,
            nn::g3d::viewer::detail::CallbackCaller& callback) NN_NOEXCEPT;

        bool ExaminesTextureFileUsed(const ResMaterialAnim* pResMatAnim, const nn::gfx::ResTextureFile* pResTextureFile) NN_NOEXCEPT;

        NN_FORCEINLINE void RelocatePacketBinPtr(nn::util::BinPtr* pBinPtr) NN_NOEXCEPT
        {
            pBinPtr->Relocate(pBinPtr);
        }

        bool IsTextureFileInitialized(nn::gfx::ResTextureFile* pResTextureFile) NN_NOEXCEPT;

        const char* GetTextureName(nn::gfx::ResTexture* pResTexture) NN_NOEXCEPT;

        void PrintTextureNames(nn::gfx::ResTextureFile* pResTextureFile) NN_NOEXCEPT;

        int GetKeyValueCount(const nn::g3d::ResAnimCurveData* targetAnimCurveData) NN_NOEXCEPT;

        size_t GetFrameArraySize(const nn::g3d::ResAnimCurveData* pResAnimCurveData) NN_NOEXCEPT;

        size_t GetKeyArraySize(const nn::g3d::ResAnimCurveData* pResAnimCurveData) NN_NOEXCEPT;

        // デバッグ用
        void PrintResAnimCurveData(const nn::g3d::ResAnimCurveData* targetAnimCurveData) NN_NOEXCEPT;

        void CopyAndFlush(void* pDestination, const void* pSource, size_t size) NN_NOEXCEPT;

        inline bool IsPowerOfTwo(size_t size) NN_NOEXCEPT
        {
            return ((size - 1) & size) == 0 && size != 0;
        }

        void UnregisterKey(void* data) NN_NOEXCEPT;
        void DeleteResFile(ResFile* pResFile, Allocator* pAllocator, nn::gfx::Device* pDevice) NN_NOEXCEPT;

        inline void FinalizeBuffers(nn::gfx::Device* pDevice, nn::gfx::Buffer* pBlockArray, int bufferCount) NN_NOEXCEPT
        {
            for (int blockIndex = 0; blockIndex < bufferCount; ++blockIndex)
            {
                nn::gfx::Buffer& block = pBlockArray[blockIndex];
                block.Finalize(pDevice);
                block.nn::gfx::Buffer::~TBuffer();
            }
        }
    }}
}}
