﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/g3d/viewer/g3d_ViewerDefine.h>
#include <nn/g3d/viewer/detail/g3d_ViewerPacketDefine.h>
#include <nn/gfx/gfx_Core.h>
#include <nn/gfx/gfx_Types.h>
#include <nn/gfx/gfx_Enum.h>

namespace nn { namespace g3d {

    class ModelObj;
    class ResMaterialAnim;

    namespace viewer { namespace detail {
        class EditModelObj;

        bool EditMaterials(nn::gfx::Device* pDevice, EditModelObj* pModelObj, const EditMaterialArg& arg) NN_NOEXCEPT;

        bool EditBones(nn::g3d::ModelObj* modelObj, const EditBoneArg& arg) NN_NOEXCEPT;

        bool EditRenderInfoArraySize(nn::g3d::ModelObj* modelObj, const char* labelName, const RenderInfoEditInfo* info) NN_NOEXCEPT;

        void SetShaderParamAnimationCurve(nn::g3d::ResMaterialAnim* resShaderParamAnim, int materialIndex) NN_NOEXCEPT;
    }}
}}

