﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "g3d_DynamicArray.h"

namespace nn { namespace g3d { namespace viewer { namespace detail {

template<typename TBuffer>
class BufferSwitcher
{
public:
    explicit BufferSwitcher(Allocator* pAllocator) NN_NOEXCEPT
        : m_Buffers(pAllocator, nn::DefaultAlignment, nullptr)
        , m_CurrentBufferIndex(0)
    {
    }

    virtual ~BufferSwitcher() NN_NOEXCEPT
    {
    }

    void AppendBuffer(TBuffer* buffer) NN_NOEXCEPT
    {
        m_Buffers.PushBack(buffer);
    }

    int GetBufferCount() const NN_NOEXCEPT
    {
        return m_Buffers.GetCount();
    }

    TBuffer* GetBuffer(int index) NN_NOEXCEPT
    {
        return m_Buffers[index];
    }

    const TBuffer* GetBuffer(int index) const NN_NOEXCEPT
    {
        return m_Buffers[index];
    }

    TBuffer* GetCurrentBuffer() NN_NOEXCEPT
    {
        return GetBuffer(m_CurrentBufferIndex);
    }

    const TBuffer* GetCurrentBuffer() const NN_NOEXCEPT
    {
        return GetBuffer(m_CurrentBufferIndex);
    }

    void SwitchCurrentBuffer() NN_NOEXCEPT
    {
        m_CurrentBufferIndex = (m_CurrentBufferIndex + 1) % m_Buffers.GetCount();
    }

private:
    DynamicArray<TBuffer*> m_Buffers;
    int m_CurrentBufferIndex;
};

}}}} // namespace nn::g3d::viewer::detail
