﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "g3d_EditBlinkingObj.h"



namespace {
    const int BlinkCountForSelecting = 4;
    const int FramesPerBlinkingForSelecting = 20;
}

namespace nn { namespace g3d { namespace viewer { namespace detail {

void BlinkingObj::StartBlinking() NN_NOEXCEPT
{
    m_RestFrameCountForBlinking = BlinkCountForSelecting * FramesPerBlinkingForSelecting;
    m_IsVisible = true;
}

bool BlinkingObj::UpdateBlinking() NN_NOEXCEPT
{
    if (m_RestFrameCountForBlinking == 0)
    {
        return false;
    }

    bool isVisible = (m_RestFrameCountForBlinking / BlinkCountForSelecting / 2) % 2 == 0;
    bool isUpdateShapeRequired = isVisible != m_IsVisible;
    if (isUpdateShapeRequired)
    {
        if (isVisible)
        {
            this->Show();
        }
        else
        {
            this->Hide();
        }

        m_IsVisible = isVisible;
    }

    --m_RestFrameCountForBlinking;
    return isUpdateShapeRequired;
}

void BlinkingObj::BreakBlinking() NN_NOEXCEPT
{
    m_RestFrameCountForBlinking = 0;
    if (this->IsVisibleByDefault())
    {
        this->Show();
    }
    else
    {
        this->Hide();
    }
}

}}}}

