﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/g3d/viewer/g3d_ViewerDefine.h>
#include "util/g3d_SynchronizedDynamicPtrArray.h"
#include "util/g3d_EditWorkBuffer.h"

namespace nn { namespace g3d {

class ModelObj;

namespace viewer {
namespace detail {

class EditSocketBase;

class EditPickup
{
public:
    explicit EditPickup(Allocator* allocator) NN_NOEXCEPT
        : m_pAllocator(allocator)
        , m_WorkBuffer(allocator, AllocateType_DynamicBuffer)
        , m_MaterialPickups(allocator, nn::g3d::detail::Alignment_Default)
        , m_PickupBufferSize(0)
    {
        NN_G3D_VIEWER_ASSERT_NOT_NULL(allocator);
    }

    ViewerResult PushMaterialPickup(const ModelObj* modelObj, int materialIndex) NN_NOEXCEPT;
    void ClearPickup() NN_NOEXCEPT;

    bool MakePickupPacket() NN_NOEXCEPT;
    bool SendPickup(EditSocketBase* socket) NN_NOEXCEPT;

private:
    size_t CalculateWorkBufferSize() NN_NOEXCEPT;
    void MakePickupPacketBuffer() NN_NOEXCEPT;

private:
    class MaterialPickup
    {
        friend class EditPickup;
    public:
        explicit MaterialPickup(const ModelObj* modelObj, int materialIndex) NN_NOEXCEPT
            : m_pModelObj(modelObj)
            , m_MaterialIndex(materialIndex)
        {}
    private:
        const ModelObj* m_pModelObj;
        int m_MaterialIndex;
    };

private:
    Allocator* m_pAllocator;
    EditWorkBuffer m_WorkBuffer;

    // このクラスで同期処理を行う必要があるのは m_MaterialPickups のみ
    SynchronizedDynamicPtrArray<MaterialPickup> m_MaterialPickups;

    size_t m_PickupBufferSize;

private:
    NN_DISALLOW_COPY(EditPickup) NN_NOEXCEPT;
};

}}}} // namespace nn::g3d::viewer::detail

