﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/g3d/viewer/g3d_ViewerDefine.h>

#include "g3d_CallbackCaller.h"
#include <nn/g3d/viewer/detail/g3d_ViewerPacketDefine.h>

namespace nn {
namespace g3d {
namespace viewer {
namespace detail {

class Allocator;
class EditCommandManager;
class EditRenderInfo;
class CommandMonitor;
class ResourceManager;

// ユーザの処理と排他的に扱わなければいけないコマンド処理を実行するクラスです。
// - コールバックをコールする処理
// - ユーザが触れるデータを書き換える処理
class EditCommandExecutor
{
public:
    EditCommandExecutor(
        Allocator* pAllocator,
        CallbackCaller* pCallback,
        EditCommandManager* pEditCommandManager) NN_NOEXCEPT;

    void ExecuteUpdateShadingModels(EditValueInfoBlock* block) NN_NOEXCEPT;
    void ExecuteUserScript(UserScriptBlock* pBlock) NN_NOEXCEPT;
    void ExecutePickup(CommandFlag command, EditValueInfoBlock* pBlock) NN_NOEXCEPT;
    void ExecuteBindAnimation(CommandFlag command, BindAnimInfoBlock* pBlock) NN_NOEXCEPT;
    void ExecuteEditAnimationCurve(CommandFlag command, AnimCurveBlock* pBlock) NN_NOEXCEPT;
    void ExecuteEditMaterial(EditValueInfoBlock* pBlock) NN_NOEXCEPT;
    void ExecuteEditRenderInfo(RenderInfoEditInfo* pInfo) NN_NOEXCEPT;
    void ExecuteUnloadFile(FileDataBlock* pBlock) NN_NOEXCEPT;
    void ExecuteSendRenderInfoDefinition(RenderInfoRecvBlock* pBlock, CommandMonitor* pCommandMonitor) NN_NOEXCEPT;

    EditRenderInfo* GetCurrentEditTargetRenderInfoDefinition()
    {
        return m_pCurrentEditTargetRenderInfoDefinition;
    }

private:
    ResourceManager* GetResourceManager();

    nn::g3d::viewer::detail::Allocator* m_pAllocator;
    CallbackCaller* m_pCallbackCaller;
    EditCommandManager* m_pEditCommandManager;
    EditRenderInfo* m_pCurrentEditTargetRenderInfoDefinition;
};

}}}}


