﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "g3d_SendRenderInfoDefinitionCommand.h"

#include "../g3d_CommandMonitor.h"

using namespace nn::g3d::viewer::detail;

nn::g3d::viewer::detail::SendRenderInfoDefinitionCommand::SendRenderInfoDefinitionCommand(
    Allocator* pAllocator,
    CommandMonitor* pMonitor) NN_NOEXCEPT
    : m_EditRenderInfos(pAllocator, nn::DefaultAlignment)
    , m_pCommandMonitor(pMonitor)
    , m_pAllocator(pAllocator)
    , m_IsExecutable(false)
{
}

nn::g3d::viewer::detail::SendRenderInfoDefinitionCommand::~SendRenderInfoDefinitionCommand() NN_NOEXCEPT
{
    for (int renderInfoIndex = 0; renderInfoIndex < m_EditRenderInfos.GetCount(); ++renderInfoIndex)
    {
        EditRenderInfo* pEditRenderInfo = m_EditRenderInfos[renderInfoIndex];
        pEditRenderInfo->~EditRenderInfo();
        m_pAllocator->Free(pEditRenderInfo);
    }
}

EditRenderInfo* nn::g3d::viewer::detail::SendRenderInfoDefinitionCommand::NewEditRenderInfo(ViewerKeyType modelKey, int materialIndex) NN_NOEXCEPT
{
    void* pBuffer = m_pAllocator->Allocate(sizeof(EditRenderInfo), nn::DefaultAlignment, AllocateType_Communication);
    NN_G3D_VIEWER_ASSERT_NOT_NULL(pBuffer);
    EditRenderInfo* pEditRenderInfo = new (pBuffer) EditRenderInfo(m_pAllocator);
    pEditRenderInfo->SetModelKey(modelKey);
    pEditRenderInfo->SetMaterialIndex(materialIndex);

    m_EditRenderInfos.PushBack(pEditRenderInfo);
    return pEditRenderInfo;
}

void nn::g3d::viewer::detail::SendRenderInfoDefinitionCommand::DeleteEditRenderInfo(EditRenderInfo* pEditRenderInfo) NN_NOEXCEPT
{
    int index = m_EditRenderInfos.IndexOf(pEditRenderInfo);
    NN_G3D_VIEWER_ASSERT(index >= 0);
    m_EditRenderInfos.EraseByIndex(index);

    pEditRenderInfo->~EditRenderInfo();
    m_pAllocator->Free(pEditRenderInfo);
}

CommandResult nn::g3d::viewer::detail::SendRenderInfoDefinitionCommand::Execute(EditSocketBase* pSocket) NN_NOEXCEPT
{
    NN_UNUSED(pSocket);
    if (!m_IsExecutable)
    {
        return CommandResult_Skipped;
    }

    NN_G3D_VIEWER_DEBUG_PRINT("Write SendRenderInfoDefinitionCommand\n");

    bool success = false;
    success = m_pCommandMonitor->SendBeginFreeze();
    NN_G3D_VIEWER_ASSERT(success);// 今は止める。

    for (int renderInfoIndex = 0; renderInfoIndex < m_EditRenderInfos.GetCount(); ++renderInfoIndex)
    {
        EditRenderInfo* pEditRenderInfo = m_EditRenderInfos[renderInfoIndex];

        success = pEditRenderInfo->SendRenderInfo(&m_pCommandMonitor->GetSocket());
        NN_G3D_VIEWER_ASSERT(success);// 今は止める。
    }

    success = m_pCommandMonitor->SendEndFreeze();
    NN_G3D_VIEWER_ASSERT(success);// 今は止める。

    return CommandResult_Success;
}
