﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/g3d/viewer/g3d_ViewerDefine.h>



#include "../anim/g3d_EditAnimObj.h"
#include "../g3d_Allocator.h"

#include <nn/g3d/g3d_MaterialAnimObj.h>

namespace nn { namespace g3d {

class ModelAnimObj;
class ResFile;

namespace viewer {
namespace detail {

class EditModelObj;

class EditShaderParamAnimObj : public EditAnimObj
{
public:
    explicit EditShaderParamAnimObj(Allocator* pAllocator, nn::g3d::ResFile* pResFile) NN_NOEXCEPT
        : EditAnimObj(pAllocator, pResFile, ViewerAnimKind_ShaderParamAnim)
        , m_pMatAnimArray(nullptr)
        , m_MatAnimCount(0)
    {
    }

    virtual ~EditShaderParamAnimObj() NN_NOEXCEPT
    {
        UnbindAllModelObjs();
        DestroyDataForEditingAnimCurve();
    }

    virtual bool CreateDataForEditingAnimCurve() NN_NOEXCEPT;
    virtual void DestroyDataForEditingAnimCurve() NN_NOEXCEPT;
    void EditCurve(
        int matAnimIndex,
        int curveIndex,
        const nn::g3d::ResAnimCurve* resAnimCurve) NN_NOEXCEPT;

protected:
    explicit EditShaderParamAnimObj(Allocator* pAllocator, nn::g3d::ResFile* pResFile, ViewerAnimKind animKind) NN_NOEXCEPT
        : EditAnimObj(pAllocator, pResFile, animKind)
        , m_pMatAnimArray(nullptr)
        , m_MatAnimCount(0)
    {
    }

    virtual BindResult SetupInternal(EditModelObj* pBindTargetEditModelObj, ModelAnimObj* pBoundAnimObj) NN_NOEXCEPT;
    virtual void ResetToOriginalValue(EditModelObj* pBoundModelObj) NN_NOEXCEPT;
    virtual ModelAnimObj* CreateAnimObj() NN_NOEXCEPT
    {
        void* buffer = m_pAllocator->Allocate(sizeof(MaterialAnimObj), nn::g3d::detail::Alignment_Default, AllocateType_Obj);
        MaterialAnimObj* pAnimObj = new (buffer) MaterialAnimObj();
        return pAnimObj;
    }

private:
    class EditShaderParamMatAnim;
    EditShaderParamMatAnim*     m_pMatAnimArray;
    int                         m_MatAnimCount;

private:
    NN_DISALLOW_COPY(EditShaderParamAnimObj);
};

class EditColorAnimObj : public EditShaderParamAnimObj
{
public:
    explicit EditColorAnimObj(Allocator* pAllocator, nn::g3d::ResFile* pResFile) NN_NOEXCEPT
        : EditShaderParamAnimObj(pAllocator, pResFile, ViewerAnimKind_ColorAnim)
    {
    }

private:
    NN_DISALLOW_COPY(EditColorAnimObj);
};

class EditTexSrtAnimObj : public EditShaderParamAnimObj
{
public:
    explicit EditTexSrtAnimObj(Allocator* pAllocator, nn::g3d::ResFile* pResFile) NN_NOEXCEPT
        : EditShaderParamAnimObj(pAllocator, pResFile, ViewerAnimKind_TextureSrtAnim)
    {
    }

private:
    NN_DISALLOW_COPY(EditTexSrtAnimObj);
};


}}}} // namespace nn::g3d::viewer::detail


