﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "g3d_EditAnimObj.h"



#include <nn/g3d/g3d_AnimObj.h>
#include <nn/g3d/g3d_ResFile.h>
#include "../g3d_Allocator.h"
#include "../g3d_ViewerDetailDefine.h"
#include <nn/diag/text/diag_SdkTextG3dviewer.h>

namespace nn { namespace g3d { namespace viewer { namespace detail {

//--------------------------------------------------------------------------------------------------

/*virtual*/void
EditAnimObj::FreeAnimObjBuffers() NN_NOEXCEPT
{
    NN_G3D_VIEWER_ASSERT_NOT_NULL_DETAIL(m_pAllocator, "%s\n", NN_G3D_VIEWER_RES_NAME(m_pResFile, GetName()));
    for (int i = 0, end = m_BoundModelInfos.GetCount(); i < end; ++i)
    {
        ModelAnimObj* pAnimObj = m_BoundModelInfos[i]->pAnimObj;
        void* buffer = pAnimObj->GetBufferPtr();
        if (buffer)
        {
            m_pAllocator->Free(buffer);
        }
    }

    m_SetupFlag = false;
}

bool EditAnimObj::ReloadResource(nn::g3d::ResFile* pResFile) NN_NOEXCEPT
{
    const char* pResName = GetResName(pResFile, ConvertToFileDataKind(GetAnimKind()));
    NN_UNUSED(pResName);
    NN_G3D_VIEWER_ASSERT_NOT_NULL_DETAIL(pResFile, "%s\n", pResName);
    NN_G3D_VIEWER_ASSERT_DETAIL(IsValidResFile(pResFile), "%s\n", pResName);

    // 新しくストアする情報を退避
    bool isSetupAlreadyDone = m_SetupFlag;
    DynamicArray<BoundModelInfo> currentBoundModelObjs(m_pAllocator, nn::g3d::detail::Alignment_Default, BoundModelInfo());
    GetBoundEditModelObjs(&currentBoundModelObjs);

    // 内部状態をクリア
    UnbindAllModelObjs();
    DestroyDataForEditingAnimCurve();

    // 再構築
    {
        SetResource(pResFile);

        {
            bool success = CreateDataForEditingAnimCurve();
            if (!success)
            {
                return false;
            }
        }

        if (isSetupAlreadyDone)
        {
            for (int i = 0, end = currentBoundModelObjs.GetCount(); i < end; ++i)
            {
                BoundModelInfo* pOldInfo = &currentBoundModelObjs[i];
                BindResult result = BindModelObj(pOldInfo->pBoundEditModelObj);
                if (!result.IsBound())
                {
                    NN_G3D_VIEWER_ERROR_LOG(
                        NN_TEXT_G3DVIEWER("モデル \"%s\" へのアニメーション \"%s\" の再バインドに失敗しました。\n"),
                        pOldInfo->pBoundEditModelObj->GetName(), GetName());
                }

                BoundModelInfo* pAddedInfo = m_BoundModelInfos[m_BoundModelInfos.GetCount() - 1];
                pAddedInfo->isPaused = pOldInfo->isPaused;
                pAddedInfo->pauseFrame = pOldInfo->pauseFrame;
            }
        }
        else
        {
            AddBoundModelObjs(currentBoundModelObjs);
        }
    }

    return true;
}

}}}}

