﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/g3d/viewer/g3d_ViewerDefine.h>
#include <nn/g3d/viewer/detail/g3d_ViewerPacketDefine.h>
#include "../g3d_ViewerDetailDefine.h"
#include "../util/g3d_ViewerUtility.h"
#include "../g3d_ViewerKeyManager.h"

namespace nn { namespace g3d {

class ModelObj;

namespace viewer { namespace detail {

class EditSocketBase;

class EditAnimControl
{
public:
    explicit EditAnimControl() NN_NOEXCEPT;

    ~EditAnimControl() NN_NOEXCEPT
    {
    }

    bool SendAnimControl(EditSocketBase* socket) NN_NOEXCEPT;

    void SetAnimFlag(bool enable, float frame) NN_NOEXCEPT
    {
        m_SendAnimFrameCtrlPacket.header.command =
            (enable ? SYSTEM_PLAY_FRAME_CTRL_COMMAND_FLAG : SYSTEM_STOP_FRAME_CTRL_COMMAND_FLAG);
        m_SendAnimFrameCtrlPacket.block.frame = frame;
    }

    void SetFrame(float value) NN_NOEXCEPT
    {
        m_SendAnimFrameCtrlPacket.header.command = SYSTEM_SEND_FRAME_COMMAND_FLAG;
        m_SendAnimFrameCtrlPacket.block.frame = value;
    }

    void SetFrameStep(float value) NN_NOEXCEPT
    {
        m_SendAnimFrameCtrlPacket.header.command = SYSTEM_SEND_FRAME_STEP_COMMAND_FLAG;
        m_SendAnimFrameCtrlPacket.block.frameStep = value;
    }

    void SetNextModelAnim(const ModelObj* pModelObj) NN_NOEXCEPT
    {
        m_SendAnimFrameCtrlPacket.header.command = SYSTEM_SEND_MODEL_NEXT_ANIM_COMMAND_FLAG;
        m_SendAnimFrameCtrlPacket.block.modelKey = ViewerKeyManager::GetInstance().FindKey(pModelObj);
        NN_G3D_VIEWER_ASSERT_VALID_KEY(m_SendAnimFrameCtrlPacket.block.modelKey);
    }

    void SetPrevModelAnim(const ModelObj* pModelObj) NN_NOEXCEPT
    {
        m_SendAnimFrameCtrlPacket.header.command = SYSTEM_SEND_MODEL_PREV_ANIM_COMMAND_FLAG;
        m_SendAnimFrameCtrlPacket.block.modelKey = ViewerKeyManager::GetInstance().FindKey(pModelObj);
        NN_G3D_VIEWER_ASSERT_VALID_KEY(m_SendAnimFrameCtrlPacket.block.modelKey);
    }
private:
    FrameCtrlPacket m_SendAnimFrameCtrlPacket;
};

}}}}

