﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "g3d_EditAnimControl.h"



#include "../g3d_EditSocket.h"
#include "../util/g3d_ViewerUtility.h"

namespace nn { namespace g3d { namespace viewer { namespace detail {

EditAnimControl::EditAnimControl() NN_NOEXCEPT
{
    m_SendAnimFrameCtrlPacket.header.command = SYSTEM_PLAY_FRAME_CTRL_COMMAND_FLAG;
    m_SendAnimFrameCtrlPacket.header.magic = NN_G3D_EDIT_MAGIC;
    m_SendAnimFrameCtrlPacket.header.verWord = NN_G3D_EDIT_VERSION;
    m_SendAnimFrameCtrlPacket.header.dataSize = sizeof(FrameCtrlBlock);
}

bool
EditAnimControl::SendAnimControl(EditSocketBase* socket) NN_NOEXCEPT
{
    NN_G3D_VIEWER_ASSERT_NOT_NULL(socket);
    m_SendAnimFrameCtrlPacket.header.dataSize = sizeof(FrameCtrlBlock);
    return socket->WriteSync(&m_SendAnimFrameCtrlPacket, sizeof(m_SendAnimFrameCtrlPacket));
}

}}}}

