﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/g3d/g3d_ResSkeleton.h>

NN_PRAGMA_PUSH_WARNINGS
NN_DISABLE_WARNING_SHADOW

namespace nn { namespace g3d {

void ResSkeleton::Reset() NN_NOEXCEPT
{
    Reset(ResetGuardFlag_None);
}

void ResSkeleton::Reset(Bit32 resetGuardFlag) NN_NOEXCEPT
{
    if ((resetGuardFlag & ResetGuardFlag_UserPtr) != ResetGuardFlag_UserPtr)
    {
        ToData().pUserPtr.Set(NULL);
    }
}

int ResSkeleton::GetBranchEndIndex(int boneIndex) const NN_NOEXCEPT
{
    // ResBone が深さ優先で格納されていることに依存する。
    // 同じ枝を辿っている間は元の親より小さなインデックスを持つことは無い。
    int boneCount = GetBoneCount();
    int branchParentIndex = GetBone(boneIndex)->GetParentIndex();
    if (boneIndex == 0)
    {
        // ルートノードは全てのノードを辿るので、branchParentIndex = -1。
        branchParentIndex = -1;
    }
    for (++boneIndex; boneIndex < boneCount; ++boneIndex)
    {
        if (GetBone(boneIndex)->GetParentIndex() <= branchParentIndex)
        {
            return boneIndex;
        }
    }
    return boneIndex;
}

void ResSkeleton::UpdateBillboardMode() NN_NOEXCEPT
{
    for (int idxBone = 0, boneCount = GetBoneCount(); idxBone < boneCount; ++idxBone)
    {
        ResBone* pBone = GetBone(idxBone);
        Bit32 bbMode = pBone->GetBillboardMode();

        if (bbMode >= ResBone::Flag_BillboardWorldViewVector)
        {
            // 子がいる場合は階層ビルボードを行う。
            if (idxBone + 1 < boneCount && idxBone == GetBone(idxBone + 1)->GetParentIndex())
            {
                pBone->ToData().billboardIndex = static_cast<uint16_t>(idxBone); // 自分自身が参照先。
            }
            else
            {
                pBone->ToData().billboardIndex = ResBone::Flag_BillboardIndexNone;
            }
        }
        else
        {
            pBone->ToData().flag &= ~ResBone::Mask_Billboard; // 確実に BILLBOARD_NONE にする。
            if (idxBone == 0)
            {
                pBone->ToData().billboardIndex = ResBone::Flag_BillboardIndexNone;
                continue;
            }

            ResBone* pParent = GetBone(pBone->GetParentIndex());
            pBone->ToData().billboardIndex = pParent->ToData().billboardIndex;

            // 親が階層ビルボードの場合は引き継ぐ。
            if (pParent->ToData().billboardIndex != ResBone::Flag_BillboardIndexNone)
            {
                pBone->ToData().flag |= ResBone::Flag_BillboardChild;
            }
        }
    }
}

}} // namespace nn::g3d

NN_PRAGMA_POP_WARNINGS
