﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/atk2/detail/atk2_AudioFrameUpdater.h>

namespace nn { namespace atk2 { namespace detail {

    AudioFrameUpdater::Result AudioFrameUpdater::Initialize() NN_NOEXCEPT
    {
        return Result_Success;
    }

    void AudioFrameUpdater::Finalize() NN_NOEXCEPT
    {
    }

    AudioFrameUpdater::Result AudioFrameUpdater::Update() NN_NOEXCEPT
    {
        bool result = true;

        Lock();

        for ( AudioFrameUpdateList::iterator itr = m_AudioFrameUpdateList.begin();
              itr != m_AudioFrameUpdateList.end();
        )
        {
            AudioFrameUpdateList::iterator curItr = itr++;
            if (!curItr->Update())
            {
                result = false;
            }
        }

        Unlock();

        return result ? Result_Success : Result_ErrorUnknown;
    }

    void AudioFrameUpdater::Lock() NN_NOEXCEPT
    {
        m_UpdateCriticalSection.Lock();
    }

    void AudioFrameUpdater::Unlock() NN_NOEXCEPT
    {
        m_UpdateCriticalSection.Unlock();
    }

    AudioFrameUpdater::Result AudioFrameUpdater::RegisterAudioFrameUpdate(IAudioFrameUpdate* pUpdate) NN_NOEXCEPT
    {
        m_AudioFrameUpdateList.push_back(*pUpdate);
        return Result_Success;
    }

    AudioFrameUpdater::Result AudioFrameUpdater::UnregisterAudioFrameUpdate(IAudioFrameUpdate* pUpdate) NN_NOEXCEPT
    {
        m_AudioFrameUpdateList.erase(m_AudioFrameUpdateList.iterator_to(*pUpdate));
        return Result_Success;
    }
}}}
