﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_SdkAssert.h>

#include <nn/audio/audio_FinalMixApi.h>
#include <nn/atk2/atk2_FinalMix.h>

namespace nn { namespace atk2 {


bool FinalMix::Initialize(nn::audio::AudioRendererConfig* pConfig, int channelCount) NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL( pConfig );
    NN_SDK_ASSERT_MINMAX( channelCount, 1, nn::audio::MixBufferCountMax );

    m_ChannelCount = channelCount;
    m_ReferenceCount = 0;
    return nn::audio::AcquireFinalMix( pConfig, &m_FinalMix, GetMixBufferCount() );
}
void FinalMix::Finalize(nn::audio::AudioRendererConfig* pConfig) NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL( pConfig );
    NN_SDK_ASSERT_EQUAL( static_cast<uint32_t>( m_ReferenceCount ), 0u );   //  FinalMix に接続されている Voice がないことを確認します。

    nn::audio::ReleaseFinalMix( pConfig, &m_FinalMix );
}
#if 0
void FinalMix::SetupEffect(EffectBase* pEffect, int bus) NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL( pEffect );
    NN_SDK_ASSERT_EQUAL( bus, 0 );  //  FinalMix は bus を 1 つしか持ちません。
    NN_UNUSED( bus );

    int8_t inputOutputChannel[ChannelIndex_Count];
    for(int i = 0; i < m_ChannelCount; i++)
    {
        inputOutputChannel[i] = static_cast<int8_t>( i );
    }
    pEffect->SetEffectInputOutput( inputOutputChannel, inputOutputChannel, m_ChannelCount, m_ChannelCount );
}
void FinalMix::SetupEffect(EffectAux* pEffect, int bus) NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL( pEffect );
    NN_SDK_ASSERT_EQUAL( bus, 0 );  //  FinalMix は bus を 1 つしか持ちません。
    NN_UNUSED( bus );

    int8_t inputOutputChannel[ChannelIndex_Count];
    for(int i = 0; i < m_ChannelCount; i++)
    {
        inputOutputChannel[i] = static_cast<int8_t>( i );
    }
    pEffect->SetEffectInputOutput( inputOutputChannel, inputOutputChannel, m_ChannelCount, m_ChannelCount );
}
#endif
OutputReceiver::ReceiverType FinalMix::GetReceiverType() const NN_NOEXCEPT
{
    return ReceiverType::ReceiverType_FinalMix;
}
int FinalMix::GetChannelCount() const NN_NOEXCEPT
{
    return m_ChannelCount;
}
int FinalMix::GetBusCount() const NN_NOEXCEPT
{
    return 1;  //  FinalMix は bus を 1 つしか持ちません。
}
void FinalMix::AddReferenceCount(int value) NN_NOEXCEPT
{
    m_ReferenceCount += value;
}

}}
