﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/atk/viewer/atk_Types.h>

#ifdef NN_ATK_CONFIG_ENABLE_DEV

#include <nn/util/util_FormatString.h>

namespace nn {
namespace atk {
namespace viewer {
namespace detail {

NN_DEFINE_STATIC_CONSTANT( const uint32_t Hash32::Size );

//----------------------------------------------------------
void
Hash32::ToString(char* buffer, uint32_t length) const NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL(buffer);
    NN_SDK_ASSERT(length >= Size * 4);

    nn::util::SNPrintf(
        buffer,
        length,
        "%02x%02x%02x%02x-%02x%02x%02x%02x-%02x%02x%02x%02x-%02x%02x%02x%02x-%02x%02x%02x%02x-%02x%02x%02x%02x-%02x%02x%02x%02x-%02x%02x%02x%02x",
        value[0], value[1], value[2], value[3],
        value[4], value[5], value[6], value[7],
        value[8], value[9], value[10], value[11],
        value[12], value[13], value[14], value[15],
        value[16], value[17], value[18], value[19],
        value[20], value[21], value[22], value[23],
        value[24], value[25], value[26], value[27],
        value[28], value[29], value[30], value[31]
    );
}

} // namespace nn::atk::viewer::detail
} // namespace nn::atk::viewer
} // namespace nn::atk
} // namespace nn

#endif // NN_ATK_CONFIG_ENABLE_DEV
