﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/atk/fnd/string/atkfnd_String.h>
#include <nn/atk/fnd/string/atkfnd_FixedString.h>

namespace nn {
namespace atk {
namespace detail {
namespace fnd {

//----------------------------------------------------------
FixedString::FixedString() NN_NOEXCEPT :
m_Buffer(NULL),
m_BufferLength(0)
{
}

//----------------------------------------------------------
FixedString::FixedString(char* buffer, int bufferLength) NN_NOEXCEPT :
m_Buffer(buffer),
m_BufferLength(bufferLength)
{
    NN_SDK_ASSERT((buffer == NULL) == (bufferLength == 0));
}

//----------------------------------------------------------
void
FixedString::Attach(char* buffer, int bufferLength) NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL(buffer);
    NN_SDK_ASSERT(bufferLength > 0);
    NN_SDK_ASSERT(!IsAttached(), "FixedString is already attached.\n");

    m_BufferLength = bufferLength;
    m_Buffer = buffer;

    // 終端文字を設定します。
    m_Buffer[m_BufferLength - 1] = '\0';
}

//----------------------------------------------------------
void
FixedString::Detach() NN_NOEXCEPT
{
    m_BufferLength = 0;
    m_Buffer = NULL;
}

//----------------------------------------------------------
void
FixedString::CopyFrom(const char* value, int length, int index/*= 0*/) NN_NOEXCEPT
{
    CopyPartFrom(value, length, index);

    // 終端文字を設定します。
    NN_SDK_ASSERT(index + length <= m_BufferLength, "buffer over flow.\n");
    m_Buffer[index + length] = '\0';
}

//----------------------------------------------------------
void
FixedString::CopyPartFrom(const char* value, int length, int index/*= 0*/) NN_NOEXCEPT
{
    NN_SDK_ASSERT(m_Buffer != NULL, "buffer is not attached.\n");
    NN_SDK_ASSERT_NOT_NULL(value);
    NN_SDK_ASSERT(index + length < m_BufferLength, "buffer over flow.\n");

    String::Copy(m_Buffer + index, m_BufferLength - index, value, length);
}

} // namespace nn::atk::detail::fnd
} // namespace nn::atk::detail
} // namespace nn::atk
} // namespace nn
