﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/atk/atk_StreamSoundFile.h>
#include <nn/atk/atk_ElementType.h>

namespace nn {
namespace atk {
namespace detail {

//
// StreamSoundFile::FileHeader
//
NN_DEFINE_STATIC_CONSTANT( const int StreamSoundFile::FileHeader::BlockCount );

const Util::ReferenceWithSize*
StreamSoundFile::FileHeader::GetReferenceBy( uint16_t typeId ) const NN_NOEXCEPT
{
    for ( int i = 0; i < dataBlocks; i++ )
    {
        if ( toBlocks[ i ].typeId == typeId )
        {
            return &toBlocks[ i ];
        }
    }
    return NULL;
}

bool StreamSoundFile::FileHeader::HasSeekBlock() const NN_NOEXCEPT
{
    const Util::ReferenceWithSize* p =
        GetReferenceBy( ElementType_StreamSoundFile_SeekBlock );
    return (p != NULL);
}
bool StreamSoundFile::FileHeader::HasRegionBlock() const NN_NOEXCEPT
{
    const Util::ReferenceWithSize* p =
        GetReferenceBy( ElementType_StreamSoundFile_RegionBlock );
    return (p != NULL);
}
bool StreamSoundFile::FileHeader::HasMarkerBlock() const NN_NOEXCEPT
{
    const Util::ReferenceWithSize* p =
        GetReferenceBy( ElementType_StreamSoundFile_MarkerBlock );
    return (p != NULL);
}

uint32_t StreamSoundFile::FileHeader::GetInfoBlockSize() const NN_NOEXCEPT
{
    const Util::ReferenceWithSize* p =
        GetReferenceBy( ElementType_StreamSoundFile_InfoBlock );
    NN_SDK_ASSERT_NOT_NULL(p);
    return p->size;
}
uint32_t StreamSoundFile::FileHeader::GetSeekBlockSize() const NN_NOEXCEPT
{
    const Util::ReferenceWithSize* p =
        GetReferenceBy( ElementType_StreamSoundFile_SeekBlock );
    NN_SDK_ASSERT_NOT_NULL(p);
    return p->size;
}
uint32_t StreamSoundFile::FileHeader::GetDataBlockSize() const NN_NOEXCEPT
{
    const Util::ReferenceWithSize* p =
        GetReferenceBy( ElementType_StreamSoundFile_DataBlock );
    NN_SDK_ASSERT_NOT_NULL(p);
    return p->size;
}
uint32_t StreamSoundFile::FileHeader::GetRegionBlockSize() const NN_NOEXCEPT
{
    const Util::ReferenceWithSize* p =
        GetReferenceBy( ElementType_StreamSoundFile_RegionBlock );
    NN_SDK_ASSERT_NOT_NULL(p);
    return p->size;
}
uint32_t StreamSoundFile::FileHeader::GetMarkerBlockSize() const NN_NOEXCEPT
{
    const Util::ReferenceWithSize* p =
        GetReferenceBy( ElementType_StreamSoundFile_MarkerBlock );
    NN_SDK_ASSERT_NOT_NULL(p);
    return p->size;
}

uint32_t StreamSoundFile::FileHeader::GetInfoBlockOffset() const NN_NOEXCEPT
{
    const Util::ReferenceWithSize* p =
        GetReferenceBy( ElementType_StreamSoundFile_InfoBlock );
    NN_SDK_ASSERT_NOT_NULL(p);
    return p->offset;
}
uint32_t StreamSoundFile::FileHeader::GetSeekBlockOffset() const NN_NOEXCEPT
{
    const Util::ReferenceWithSize* p =
        GetReferenceBy( ElementType_StreamSoundFile_SeekBlock );
    NN_SDK_ASSERT_NOT_NULL(p);
    return p->offset;
}
uint32_t StreamSoundFile::FileHeader::GetDataBlockOffset() const NN_NOEXCEPT
{
    const Util::ReferenceWithSize* p =
        GetReferenceBy( ElementType_StreamSoundFile_DataBlock );
    NN_SDK_ASSERT_NOT_NULL(p);
    return p->offset;
}
uint32_t StreamSoundFile::FileHeader::GetRegionBlockOffset() const NN_NOEXCEPT
{
    const Util::ReferenceWithSize* p =
        GetReferenceBy( ElementType_StreamSoundFile_RegionBlock );
    NN_SDK_ASSERT_NOT_NULL(p);
    return p->offset;
}
uint32_t StreamSoundFile::FileHeader::GetMarkerBlockOffset() const NN_NOEXCEPT
{
    const Util::ReferenceWithSize* p =
        GetReferenceBy( ElementType_StreamSoundFile_MarkerBlock );
    NN_SDK_ASSERT_NOT_NULL(p);
    return p->offset;
}


//
// StreamSoundFile::InfoBlockBody
//

const StreamSoundFile::StreamSoundInfo*
StreamSoundFile::InfoBlockBody::GetStreamSoundInfo() const NN_NOEXCEPT
{
    if ( toStreamSoundInfo.typeId != ElementType_StreamSoundFile_StreamSoundInfo )
    {
        return NULL;
    }
    return static_cast<const StreamSoundInfo*>(
            util::ConstBytePtr( this, toStreamSoundInfo.offset ).Get() );
}
const StreamSoundFile::TrackInfoTable*
StreamSoundFile::InfoBlockBody::GetTrackInfoTable() const NN_NOEXCEPT
{
    if ( toTrackInfoTable.typeId != ElementType_Table_ReferenceTable )
    {
        return NULL;
    }
    return static_cast<const TrackInfoTable*>(
            util::ConstBytePtr( this, toTrackInfoTable.offset ).Get() );
}
const StreamSoundFile::ChannelInfoTable*
StreamSoundFile::InfoBlockBody::GetChannelInfoTable() const NN_NOEXCEPT
{
    if ( toChannelInfoTable.typeId != ElementType_Table_ReferenceTable )
    {
        return NULL;
    }
    return static_cast<const ChannelInfoTable*>(
            util::ConstBytePtr( this, toChannelInfoTable.offset ).Get() );
}

//
// StreamSoundFile::TrackInfoTable
//
const StreamSoundFile::TrackInfo*
StreamSoundFile::TrackInfoTable::GetTrackInfo( uint32_t index ) const NN_NOEXCEPT
{
    return static_cast<const TrackInfo*>(
            table.GetReferedItem( index, ElementType_StreamSoundFile_TrackInfo ) );
}

//
// StreamSoundFile::ChannelInfoTable
//
const StreamSoundFile::ChannelInfo*
StreamSoundFile::ChannelInfoTable::GetChannelInfo( uint32_t index ) const NN_NOEXCEPT
{
    NN_SDK_ASSERT( index < table.count );

    return static_cast<const ChannelInfo*>(
            table.GetReferedItem(
                index,
                ElementType_StreamSoundFile_ChannelInfo ) );
}

//
// StreamSoundFile::ChannelInfo
//
const StreamSoundFile::DspAdpcmChannelInfo*
StreamSoundFile::ChannelInfo::GetDspAdpcmChannelInfo() const NN_NOEXCEPT
{
    if ( ! toDetailChannelInfo.IsValidTypeId( ElementType_Codec_DspAdpcmInfo ) )
    {
        return NULL;
    }

    return reinterpret_cast<const DspAdpcmChannelInfo*>(
            util::ConstBytePtr( this, toDetailChannelInfo.offset ).Get() );
}

} // namespace nn::atk::detail
} // namespace nn::atk
} // namespace nn

