﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/atk/atk_Config.h>
#include <nn/atk/atk_DecodeAdpcm.h>

namespace nn {
namespace atk {
namespace detail {

namespace
{
}

void DecodeDspAdpcm(
        position_t playPosition,            // adpcmData から数えたデコード開始位置
        nn::atk::AdpcmContext& context,     // デコード用 ADPCM コンテキスト
        const nn::atk::AdpcmParam& param,   // デコード用 ADPCM パラメータ
        const void* adpcmData,              // ADPCM エンコードデータ
        size_t decodeSamples,               // デコードサンプル数
        int16_t* dest ) NN_NOEXCEPT         // デコードデータ出力先
{
    position_t frame = playPosition / 14;
    position_t frameFrac = playPosition - frame * 14;
    const uint8_t* frameBegin = reinterpret_cast<const uint8_t*>(reinterpret_cast<uintptr_t>(adpcmData) + (frame * 8));

    int32_t pred  = static_cast<int32_t>(context.audioAdpcmContext.predScale >> 4);
    int32_t scale = static_cast<int32_t>(context.audioAdpcmContext.predScale & 0xf);

    for( unsigned i = 0; i < decodeSamples; i++ )
    {
        if ( frameFrac == 0 )
        {
            const uint8_t pred_scale = *frameBegin;
            context.audioAdpcmContext.predScale = pred_scale;
            pred = (pred_scale >> 4);
            scale = (pred_scale & 0xf);
        }

        uint8_t code = frameBegin[frameFrac / 2 + 1];
        if ( frameFrac & 0x1 )
        {
            code &= 0xf;
        }
        else
        {
            code >>= 4;
        }

        int16_t nibble = code;
        nibble <<= 12;
        nibble >>= 1;

        int16_t a1   = static_cast<int16_t>(param.coefficients[pred * 2 + 0]);
        int16_t a2   = static_cast<int16_t>(param.coefficients[pred * 2 + 1]);
        int16_t gain = static_cast<int16_t>(1 << scale);

        int32_t val = a1 * static_cast<int16_t>(context.audioAdpcmContext.history[0]);
        val  += a2 * static_cast<int16_t>(context.audioAdpcmContext.history[1]);
        val  += gain * nibble;
        val >>= 10;
        val  += 1;
        val >>= 1;

        if (val > 32767)
        {
            val = 32767;
        }
        else if (val < -32768)
        {
            val = -32768;
        }
        int16_t smp = static_cast<int16_t>(val);

        context.audioAdpcmContext.history[1] = context.audioAdpcmContext.history[0];
        context.audioAdpcmContext.history[0] = smp;

        *dest = smp;
        ++dest;

        frameFrac++;
        if ( frameFrac == 14 )
        {
            frameFrac = 0;
            frameBegin += 8;
        }
    }
}


}}}
