﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/atk/atk_WaveFile.h>
#include <nn/atk/atk_ElementType.h>

namespace nn {
namespace atk {
namespace detail {

//
// WaveFile::FileHeader
//
const WaveFile::InfoBlock* WaveFile::FileHeader::GetInfoBlock() const NN_NOEXCEPT
{
    return reinterpret_cast<const InfoBlock*>( GetBlock( ElementType_WaveFile_InfoBlock ) );
}

const WaveFile::DataBlock* WaveFile::FileHeader::GetDataBlock() const NN_NOEXCEPT
{
    return reinterpret_cast<const DataBlock*>( GetBlock( ElementType_WaveFile_DataBlock ) );
}


//
// WaveFile::InfoBlockBody
//
const WaveFile::ChannelInfo&
WaveFile::InfoBlockBody::GetChannelInfo( int channelIndex ) const NN_NOEXCEPT
{
    NN_SDK_ASSERT( channelIndex < GetChannelCount() );
    return *reinterpret_cast<const ChannelInfo*>(
            channelInfoReferenceTable.GetReferedItem( channelIndex ) );
}


//
// WaveFile::ChannelInfo
//
const void*
WaveFile::ChannelInfo::GetSamplesAddress( const void* dataBlockBodyAddress ) const NN_NOEXCEPT
{
    return reinterpret_cast<const void*>(
            util::ConstBytePtr( dataBlockBodyAddress, referToSamples.offset ).Get() );
}

const WaveFile::DspAdpcmInfo&
WaveFile::ChannelInfo::GetDspAdpcmInfo() const NN_NOEXCEPT
{
    return *reinterpret_cast<const DspAdpcmInfo*>(
            util::ConstBytePtr( this, referToAdpcmInfo.offset ).Get() );
}


} // namespace nn::atk::detail
} // namespace nn::atk
} // namespace nn
