﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/atk/atk_StartInfoReader.h>

namespace nn { namespace atk { namespace detail {

    StartInfoReader::StartInfoReader(const SoundArchive::SoundInfo& soundInfo) NN_NOEXCEPT
    : m_StartOffsetType(SoundStartable::StartInfo::StartOffsetType_MilliSeconds)
    , m_StartOffset(0)
    , m_DelayTime(0)
    , m_DelayCount(0)
    , m_UpdateType(UpdateType_AudioFrame)
    , m_PlayerPriority(soundInfo.playerPriority)
    , m_PlayerId(soundInfo.playerId)
    , m_ActorPlayerId(soundInfo.actorPlayerId)
    , m_pSeqInfo(nullptr)
    , m_pStrmInfo(nullptr)
    , m_pStrmMetaInfo(nullptr)
    , m_pStrmMetaInfo2(nullptr)
    , m_pWsdInfo(nullptr)
    , m_pLoopInfo(nullptr)
    , m_SubMixIndex(0)
    , m_pOutputReceiver(nullptr)
    {
    }

    void StartInfoReader::Read(const SoundStartable::StartInfo* startInfo) NN_NOEXCEPT
    {
        if ( startInfo != NULL )
        {
            if ( startInfo->enableFlag & SoundStartable::StartInfo::EnableFlagBit_StartOffset )
            {
                m_StartOffsetType = startInfo->startOffsetType;
                m_StartOffset = startInfo->startOffset;
            }
            if ( startInfo->enableFlag & SoundStartable::StartInfo::EnableFlagBit_PlayerPriority )
            {
                m_PlayerPriority = startInfo->playerPriority;
            }
            if ( startInfo->enableFlag & SoundStartable::StartInfo::EnableFlagBit_PlayerId )
            {
                m_PlayerId = startInfo->playerId;
            }
            if ( startInfo->enableFlag & SoundStartable::StartInfo::EnableFlagBit_ActorPlayerId )
            {
                m_ActorPlayerId = startInfo->actorPlayerId;
            }
            if ( startInfo->enableFlag & SoundStartable::StartInfo::EnableFlagBit_SequenceSoundInfo )
            {
                m_pSeqInfo = &startInfo->sequenceSoundInfo;
            }
            if ( startInfo->enableFlag & SoundStartable::StartInfo::EnableFlagBit_StreamSoundInfo )
            {
                m_pStrmInfo = &startInfo->streamSoundInfo;
            }
            if ( startInfo->enableFlag & SoundStartable::StartInfo::EnableFlagBit_StreamSoundMetaInfo )
            {
                m_pStrmMetaInfo = &startInfo->streamSoundMetaInfo;
            }
            if ( startInfo->enableFlag & SoundStartable::StartInfo::EnableFlagBit_StreamSoundMetaInfo2 )
            {
                m_pStrmMetaInfo2 = &startInfo->streamSoundMetaInfo2;
            }
            if ( startInfo->enableFlag & SoundStartable::StartInfo::EnableFlagBit_WaveSoundInfo )
            {
                m_pWsdInfo = &startInfo->waveSoundInfo;
            }
            if ( startInfo->enableFlag & SoundStartable::StartInfo::EnableFlagBit_DelayTime )
            {
                m_DelayTime = startInfo->delayTime;
            }
            if ( startInfo->enableFlag & SoundStartable::StartInfo::EnableFlagBit_DelayCount && !(startInfo->enableFlag & SoundStartable::StartInfo::EnableFlagBit_DelayTime) )
            {
                m_DelayCount = startInfo->delayCount;
            }
            if ( startInfo->enableFlag & SoundStartable::StartInfo::EnableFlagBit_UpdateType )
            {
                m_UpdateType = startInfo->updateType;
            }
            if ( startInfo->enableFlag & SoundStartable::StartInfo::EnableFlagBit_SubMixIndex )
            {
                m_SubMixIndex = startInfo->subMixIndex;
            }
            if ( startInfo->enableFlag & SoundStartable::StartInfo::EnableFlagBit_OutputReceiver )
            {
                NN_SDK_REQUIRES_NOT_NULL( startInfo->pOutputReceiver );
                m_pOutputReceiver = startInfo->pOutputReceiver;
            }
            if (startInfo->enableFlag & SoundStartable::StartInfo::EnableFlagBit_LoopInfo)
            {
                m_pLoopInfo = &startInfo->loopInfo;
            }
        }
    }

} // namespace nn::atk::detail
} // namespace nn::atk
} // namespace nn

