﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/atk/detail/atk_AddonSoundArchiveContainer.h>

#include <nn/util/util_StringUtil.h>
#include <nn/atk/atk_GroupFileReader.h>
#include <nn/atk/detail/atk_MemoryFileStream.h>

namespace nn { namespace atk { namespace detail {

    NN_DEFINE_STATIC_CONSTANT( const int AddonSoundArchiveContainer::SoundArchiveNameLengthMax );

    AddonSoundArchiveContainer::AddonSoundArchiveContainer() NN_NOEXCEPT
    : m_IsActive(false)
    , m_pSoundArchive(nullptr)
    , m_pSoundDataManager(nullptr)
    {
    }

    AddonSoundArchiveContainer::~AddonSoundArchiveContainer() NN_NOEXCEPT
    {
        m_pSoundDataManager = nullptr;
        m_pSoundArchive = nullptr;
        m_IsActive = false;
    }

    bool AddonSoundArchiveContainer::Initialize( const char* soundArchiveName, const nn::atk::AddonSoundArchive* pSoundArchive, const nn::atk::SoundDataManager* pSoundDataManager ) NN_NOEXCEPT
    {
        nn::util::Strlcpy(m_SoundArchiveName, soundArchiveName, SoundArchiveNameLengthMax);

        m_pSoundArchive = pSoundArchive;
        m_pSoundDataManager = pSoundDataManager;

        m_IsActive = true;

        return true;
    }

    void AddonSoundArchiveContainer::Finalize() NN_NOEXCEPT
    {
        m_IsActive = false;

        m_pSoundDataManager = nullptr;
        m_pSoundArchive = nullptr;
        m_SoundArchiveName[0] = '\0';
    }

    bool AddonSoundArchiveContainer::IsSameName(const char* name) const NN_NOEXCEPT
    {
        int nameLength = nn::util::Strnlen(name, SoundArchiveNameLengthMax);
        if (nameLength == SoundArchiveNameLengthMax)
        {
            // 最大長と同じ場合は、一致しているか判別できないため一致していない扱いとする
            return false;
        }

        int result = nn::util::Strncmp(name, m_SoundArchiveName, SoundArchiveNameLengthMax);
        return result == 0;
    }

    void AddonSoundArchiveContainer::SetAddTick(const nn::os::Tick& tick) NN_NOEXCEPT
    {
        m_AddTick = tick;
    }

}}}
