﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/atk/atk_WaveSoundHandle.h>
#include <nn/atk/atk_SoundHandle.h>

namespace nn {
namespace atk {

WaveSoundHandle::WaveSoundHandle( SoundHandle* handle ) NN_NOEXCEPT
: m_pSound( NULL )
{
    if ( handle == NULL ) return;

    // 汎用ハンドルからサウンドを取得
    if ( !handle->IsAttachedSound() ) return;

    detail::WaveSound* sound =
        detail::fnd::DynamicCast<detail::WaveSound*>( handle->detail_GetAttachedSound() );

    if ( sound != NULL )
    {
        // シーケンスサウンドなら一時ハンドルとしてAttachする
        detail_AttachSoundAsTempHandle( sound );
    }
}

void WaveSoundHandle::ForceStop() NN_NOEXCEPT
{
    if ( IsAttachedSound() )
    {
        m_pSound->ForceStop();
    }
}

/*--------------------------------------------------------------------------------*
  Name:         detail_AttachSoundAsTempHandle

  Description:  ハンドルにサウンドを関連付ける

  Arguments:    sound - 関連付けるサウンド

  Returns:      None.
 *--------------------------------------------------------------------------------*/
void WaveSoundHandle::detail_AttachSoundAsTempHandle( detail::WaveSound* sound ) NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL( sound );

    m_pSound = sound;

    // 一時ハンドルとしてAttachする
    if ( m_pSound->IsAttachedTempSpecialHandle() )
    {
        m_pSound->DetachTempSpecialHandle();
    }
    m_pSound->m_pTempSpecialHandle = this;
}

/*--------------------------------------------------------------------------------*
  Name:         DetachSound

  Description:  ハンドルに結びついているサウンドの関連を外す

  Arguments:    None.

  Returns:      None.
 *--------------------------------------------------------------------------------*/
void WaveSoundHandle::DetachSound() NN_NOEXCEPT
{
    if ( IsAttachedSound() )
    {
        if ( m_pSound->m_pTempSpecialHandle == this ) m_pSound->m_pTempSpecialHandle = NULL;
    }
    if ( m_pSound != NULL ) m_pSound = NULL;
}

} // namespace nn::atk
} // namespace nn

