﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn { namespace atk2 { namespace detail {

    struct WaveBuffer;

    // @brief 波形バッファのリストです
    class WaveBufferList
    {
    public:
        // @brief コンストラクタです
        WaveBufferList() NN_NOEXCEPT;

        // @brief リスト先頭の波形バッファを取得します
        WaveBuffer* PeekFront() NN_NOEXCEPT;
        // @brief リスト先頭の波形バッファを破棄します
        WaveBuffer* PopFront() NN_NOEXCEPT;
        // @brief リストに波形バッファを追加します
        bool PushBack(WaveBuffer* pWaveBuffer) NN_NOEXCEPT;
        // @brief リストの波形バッファをクリアします
        void Clear() NN_NOEXCEPT;

    private:
        WaveBuffer* m_pWaveBufferListBegin;
        WaveBuffer* m_pWaveBufferListEnd;
    };

}}}

