﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/atk2/detail/atk2_Adpcm.h>

namespace nn { namespace atk2 { namespace detail {

    enum SampleFormat
    {
        SampleFormat_PcmS8,       //!< 符号付き 8 ビットフォーマットです。 // TODO: 非サポートのため WaveFileReader でエラーにする
        SampleFormat_PcmS16,      //!< 符号付き 16 ビットフォーマットです。
        SampleFormat_Adpcm,       //!< Aspcm フォーマットです。
        SampleFormat_PcmS32       //!< 符号付き 32 ビットフォーマットです。
    };

    enum WaveBufferState
    {
        WaveBufferState_Free, //!< 初期状態（一度もAppendWaveBuffer で追加されていない状態）を表します。ボイスの管理外にあります。
        WaveBufferState_Wait, //!< ボイスのバッファリストにリンクされ、再生待ちの状態を表します。ボイスが管理しています。
        WaveBufferState_Play, //!< 現在再生中の状態を表します。ボイスが管理しています。
        WaveBufferState_Done  //!< 再生完了状態を表します。ボイスの管理外にあります。
    };

    struct WaveBuffer
    {
        // 波形のメタデータ
        size_t bufferSize;
        const void * bufferAddress;         //!< サンプルデータ格納先アドレス。必須です。ボイスに登録後は変更しないで下さい。
        size_t sampleLength;                //!< バッファ内のサンプル長。必須です。ボイスに登録後は変更しないで下さい。
        const AdpcmContext* pAdpcmContext; //!< Adpcm コンテクストのアドレス。ボイスに登録後、バッファの再生が終了するまで変更しないで下さい。
        bool loopFlag;                      //!< ループフラグ。任意です。

        // 内部管理用
        uint32_t sampleOffset; //!< サンプルオフセットです
        WaveBufferState state; //!< バッファの状態。ライブラリが使用するため、変更しないで下さい。
        WaveBuffer* next;      //!< 次のバッファ構造体のアドレス。ライブラリが使用するため、変更しないで下さい。
        void* userParam;       //!< ユーザーパラメータ。任意です。
    };

}}}

