﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/fs.h>

namespace nn {
namespace atk {

//! @internal
//! @brief  ファイルシステム上のファイルを読み込むことのできる簡単なクラスです。
class FileReader
{
public:
    enum Origin
    {
        ORIGIN_BEGIN,
        ORIGIN_CURRENT,
        ORIGIN_END
    };

    enum Result
    {
        Result_Success,
        Result_NotInitialized,
        Result_NotOpen,
        Result_InvalidArgument,
        Result_FailedOpenFile,
        Result_FailedGetFilesize,
        Result_FailedReadFile,
        Result_FailedSeekFile
    };

    FileReader() NN_NOEXCEPT;
    virtual ~FileReader() NN_NOEXCEPT;

    Result Initialize() NN_NOEXCEPT;
    Result Finalize() NN_NOEXCEPT;

    Result Open(const char* path) NN_NOEXCEPT;
    Result Close() NN_NOEXCEPT;
    bool IsOpen() const NN_NOEXCEPT { return m_IsOpen; }

    Result Read(void* buf, uint32_t length, int32_t* readSize) NN_NOEXCEPT;
    Result Seek(int32_t offset, Origin origin = ORIGIN_BEGIN) NN_NOEXCEPT;
    uint32_t GetSize() const NN_NOEXCEPT { return m_FileSize; }
    uint32_t Tell() const NN_NOEXCEPT { return m_FilePosition; }

private:
    uint32_t m_FilePosition;
    uint32_t m_FileSize;
    bool m_IsInitialized;
    bool m_IsOpen;
#if defined(NN_BUILD_CONFIG_TOOLCHAIN_CLANG)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif
    uint8_t m_Padding[2];
#if defined(NN_BUILD_CONFIG_TOOLCHAIN_CLANG)
#pragma clang diagnostic pop
#endif

    nn::fs::FileHandle m_FileHandle;
};

} // namespace nn::atk
} // namespace nn

